/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PortletMetaDataResource
implements Serializable {
    static final long serialVersionUID = 2L;
    private Map metadataMap = new HashMap();

    public PortletMetaDataResource(ResourceBundle bundle) {
        if (bundle != null) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (key.equals("javax.portlet.title")) {
                    this.metadataMap.put("javax.portlet.title", bundle.getString("javax.portlet.title"));
                    continue;
                }
                if (key.equals("javax.portlet.short-title")) {
                    this.metadataMap.put("javax.portlet.short-title", bundle.getString("javax.portlet.short-title"));
                    continue;
                }
                if (!key.equals("javax.portlet.keywords")) continue;
                this.metadataMap.put("javax.portlet.keywords", bundle.getString("javax.portlet.keywords"));
            }
        }
    }

    public String getTitle() {
        return (String)this.metadataMap.get("javax.portlet.title");
    }

    public String getShortTitle() {
        return (String)this.metadataMap.get("javax.portlet.short-title");
    }

    public String getKeywords() {
        return (String)this.metadataMap.get("javax.portlet.keywords");
    }

    public List getKeywordsList() {
        return this.getListProperty("javax.portlet.keywords");
    }

    public String getString(String key) {
        String value = null;
        if (key != null) {
            if (key.equals("javax.portlet.title")) {
                value = this.getTitle();
            } else if (key.equals("javax.portlet.short-title")) {
                value = this.getShortTitle();
            } else if (key.equals("javax.portlet.keywords")) {
                value = this.getKeywords();
            }
        }
        return value;
    }

    public boolean hasData() {
        return this.metadataMap.size() > 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.metadataMap.isEmpty()) {
            String newLine = System.getProperty("line.separator");
            for (String key : this.metadataMap.keySet()) {
                sb.append(key).append("=").append(this.metadataMap.get(key)).append(newLine);
            }
        }
        return sb.toString();
    }

    private List getListProperty(String key) {
        ArrayList<String> retval = new ArrayList<String>();
        String strValue = (String)this.metadataMap.get(key);
        if (strValue != null) {
            StringTokenizer st = new StringTokenizer(strValue, ",", false);
            while (st.hasMoreTokens()) {
                String keyword = st.nextToken().trim();
                retval.add(keyword);
            }
        }
        return retval;
    }
}

