/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import com.sun.portal.portletcontainer.common.descriptor.PreferenceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class PortletPreferencesDescriptor {
    public static final String PREFERENCE = "preference";
    public static final String PREFERENCES_VALIDATOR = "preferences-validator";
    private List<PreferenceDescriptor> preferenceDescriptors;
    private String portletName;
    private String validatorName;
    private static Logger logger = ContainerLogger.getLogger(PortletPreferencesDescriptor.class, (String)"PCCLogMessages");

    public PortletPreferencesDescriptor(String portletName) {
        this.portletName = portletName;
        this.preferenceDescriptors = new ArrayList<PreferenceDescriptor>();
    }

    public void load(Element element, String namespaceURI) {
        List<Element> preferenceElements = PortletXMLDocumentHelper.getChildElements(element, PREFERENCE);
        if (preferenceElements.isEmpty()) {
            logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0014", this.portletName);
        }
        int numPreference = preferenceElements.size();
        for (int i = 0; i < numPreference; ++i) {
            Element preferenceElement = preferenceElements.get(i);
            PreferenceDescriptor preferenceDescriptor = new PreferenceDescriptor(this.portletName);
            preferenceDescriptor.load(preferenceElement, namespaceURI);
            this.preferenceDescriptors.add(preferenceDescriptor);
        }
        this.validatorName = PortletXMLDocumentHelper.getChildTextTrim(element, PREFERENCES_VALIDATOR);
    }

    public List getPreferenceDescriptors() {
        return this.preferenceDescriptors;
    }

    public PreferenceDescriptor getPreferenceDescriptor(String preferenceName) {
        PreferenceDescriptor preference = null;
        boolean stop = false;
        Iterator<PreferenceDescriptor> iterator = this.preferenceDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            PreferenceDescriptor preferenceDescriptor = iterator.next();
            if (!preferenceDescriptor.getPrefName().equals(preferenceName)) continue;
            preference = preferenceDescriptor;
            stop = true;
        }
        return preference;
    }

    public String getPreferencesValidatorName() {
        return this.validatorName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletPreferencesDescriptor [");
        for (PreferenceDescriptor preferenceDescriptor : this.preferenceDescriptors) {
            sb.append(preferenceDescriptor.toString());
        }
        if (this.validatorName != null) {
            sb.append(" preferences validator name [");
            sb.append(this.validatorName);
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

