/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMap
implements MultiValueMap<String, String> {
    private final Map<String, List<String>> parameters;

    protected ParameterMap() {
        this(null);
    }

    protected ParameterMap(Map<String, List<String>> parameters) {
        this.parameters = parameters != null ? parameters : new LinkedMultiValueMap();
    }

    public void clear() {
        this.parameters.clear();
    }

    public boolean containsKey(Object key) {
        return this.parameters.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.parameters.containsKey(value);
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.parameters.entrySet();
    }

    public List<String> get(Object key) {
        return this.parameters.get(key);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Set<String> keySet() {
        return this.parameters.keySet();
    }

    public List<String> put(String key, List<String> values) {
        return this.parameters.put(key, values);
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        this.parameters.putAll(map);
    }

    public List<String> remove(Object key) {
        return this.parameters.remove(key);
    }

    public int size() {
        return this.parameters.size();
    }

    public Collection<List<String>> values() {
        return this.parameters.values();
    }

    public String getFirst(String key) {
        List<String> values = this.parameters.get(key);
        return values != null ? values.get(0) : null;
    }

    public void add(String key, String value) {
        List<String> values = this.parameters.get(key);
        if (values == null) {
            values = new LinkedList<String>();
            this.parameters.put(key, values);
        }
        values.add(value);
    }

    public void set(String key, String value) {
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        this.parameters.put(key, values);
    }

    public void setAll(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.parameters.size());
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get(0));
        }
        return map;
    }
}

