/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.SigningSupport;
import org.springframework.social.support.HttpRequestDecorator;

class OAuth1RequestInterceptor
implements ClientHttpRequestInterceptor {
    private final SigningSupport signingUtils;
    private final OAuth1Credentials oauth1Credentials;

    public OAuth1RequestInterceptor(OAuth1Credentials oauth1Credentials) {
        this.oauth1Credentials = oauth1Credentials;
        this.signingUtils = new SigningSupport();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestDecorator protectedResourceRequest = new HttpRequestDecorator(request);
        protectedResourceRequest.getHeaders().add("Authorization", this.getAuthorizationHeaderValue(request, body));
        return execution.execute((HttpRequest)protectedResourceRequest, body);
    }

    private String getAuthorizationHeaderValue(HttpRequest request, byte[] body) {
        return this.signingUtils.buildAuthorizationHeaderValue(request, body, this.oauth1Credentials);
    }
}

