/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.coordinates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.node.coordinates.model.CoordinatePK;
import org.silverpeas.core.node.coordinates.model.CoordinatePoint;
import org.silverpeas.core.node.coordinates.model.CoordinateRuntimeException;
import org.silverpeas.core.node.coordinates.service.CoordinatesService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
public class CoordinateImportExport {
    private static final String NODE_SETTINGS_PATH = "org.silverpeas.node.nodeSettings";
    private static final String SORT_FIELD = "sortField";
    private static final String NODE_PATH_DEFAULT_VALUE = "nodepath";
    private static final String SORT_ORDER = "sortOrder";
    @Inject
    private NodeService nodeService;
    @Inject
    private CoordinatesService coordinatesService;

    protected CoordinateImportExport() {
    }

    public int addPositions(String componentId, String axisPath) {
        List<String> combination = this.getArrayCombination(axisPath);
        int coordinateId = 0;
        NodePK axisPK = new NodePK("toDefine", componentId);
        CoordinatePK coordinatePK = new CoordinatePK("unknown", (WAPrimaryKey)axisPK);
        try {
            ArrayList<CoordinatePoint> allnodes = new ArrayList<CoordinatePoint>();
            int i = 1;
            for (String nodeId : combination) {
                NodePK nodePK = new NodePK(nodeId, componentId);
                NodePath path = this.nodeService.getPath(nodePK);
                for (NodeDetail nodeDetail : path) {
                    String anscestorId = nodeDetail.getNodePK().getId();
                    int nodeLevel = nodeDetail.getLevel();
                    if (nodeDetail.getNodePK().isRoot()) continue;
                    CoordinatePoint point = anscestorId.equals(nodeId) ? new CoordinatePoint(-1, Integer.parseInt(anscestorId), true, nodeLevel, i) : new CoordinatePoint(-1, Integer.parseInt(anscestorId), false, nodeLevel, i);
                    allnodes.add(point);
                }
                ++i;
            }
            coordinateId = this.getCoordinatesService().addCoordinate(coordinatePK, allnodes);
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException("Adding coordinates combination failure", (Throwable)e);
        }
        return coordinateId;
    }

    public NodeDetail getNodeDetailByName(String name, int nodeRootId, String componentId) {
        try {
            return this.getNodeService().getDetailByNameAndFatherId(new NodePK("useless", componentId), name, nodeRootId);
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException((Throwable)e);
        }
    }

    private List<String> getArrayCombination(String valuePath) {
        StringTokenizer st = new StringTokenizer(valuePath, ",");
        ArrayList<String> combination = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String axisValue = st.nextToken();
            axisValue = axisValue.substring(axisValue.lastIndexOf(47) + 1, axisValue.length());
            combination.add(axisValue);
        }
        return combination;
    }

    public List<String> getCombinationLabels(List<String> combination, String componentId) {
        ArrayList<String> coordinatesLabels = new ArrayList<String>();
        for (String position : combination) {
            StringTokenizer st = new StringTokenizer(position, "/");
            StringBuilder pathName = new StringBuilder();
            while (st.hasMoreTokens()) {
                String nodeId = st.nextToken();
                NodeDetail nodeDetail = this.getNodeHeader(nodeId, componentId);
                if (nodeDetail.getLevel() <= 1) continue;
                if (nodeDetail.getLevel() == 2) {
                    pathName.append("<b>").append(nodeDetail.getName()).append("</b>").append(" > ");
                    continue;
                }
                if (!st.hasMoreTokens()) {
                    pathName.append(nodeDetail.getName()).append("<br />");
                    continue;
                }
                pathName.append(nodeDetail.getName()).append(" > ");
            }
            coordinatesLabels.add(pathName.toString());
        }
        return coordinatesLabels;
    }

    public Collection<NodeDetail> getPathOfNode(NodePK nodePk) {
        return this.getNodeService().getPath(nodePk);
    }

    public List<NodeDetail> getAxis(String componentId) {
        SettingBundle nodeSettings = ResourceLocator.getSettingBundle((String)NODE_SETTINGS_PATH);
        String sortField = nodeSettings.getString(SORT_FIELD, NODE_PATH_DEFAULT_VALUE);
        String sortOrder = nodeSettings.getString(SORT_ORDER, "asc");
        ArrayList<NodeDetail> axis = new ArrayList<NodeDetail>();
        try {
            List<NodeDetail> headers = this.getAxisHeaders(componentId);
            NodeDetail header = null;
            for (int h = 0; h < headers.size(); ++h) {
                header = headers.get(h);
                if ("Invisible".equals(header.getStatus())) continue;
                axis.addAll(this.getNodeService().getSubTree(header.getNodePK(), sortField + " " + sortOrder));
            }
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException("Getting axis failure", (Throwable)e);
        }
        return axis;
    }

    public List<NodeDetail> getAxisHeadersWithChildren(String componentId, boolean includeUnclassified, boolean takeAxisInChildrenList) {
        SettingBundle nodeSettings = ResourceLocator.getSettingBundle((String)NODE_SETTINGS_PATH);
        String sortField = nodeSettings.getString(SORT_FIELD, NODE_PATH_DEFAULT_VALUE);
        String sortOrder = nodeSettings.getString(SORT_ORDER, "asc");
        ArrayList<NodeDetail> axis = new ArrayList<NodeDetail>();
        try {
            List<NodeDetail> headers = this.getAxisHeaders(componentId);
            for (NodeDetail header : headers) {
                if (Integer.parseInt(header.getNodePK().getId()) <= 1 || !includeUnclassified) continue;
                List children = this.getNodeService().getSubTree(header.getNodePK(), sortField + " " + sortOrder);
                if (!takeAxisInChildrenList) {
                    children.remove(children.iterator().next());
                }
                header.setChildrenDetails((Collection)children);
                axis.add(header);
            }
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException("Getting axis failure", (Throwable)e);
        }
        return axis;
    }

    public List getAxisChildren(NodePK nodePK, boolean takeAxisInChildrenList) {
        SettingBundle nodeSettings = ResourceLocator.getSettingBundle((String)NODE_SETTINGS_PATH);
        String sortField = nodeSettings.getString(SORT_FIELD, NODE_PATH_DEFAULT_VALUE);
        String sortOrder = nodeSettings.getString(SORT_ORDER, "asc");
        try {
            List children = this.getNodeService().getSubTree(nodePK, sortField + " " + sortOrder);
            if (!takeAxisInChildrenList) {
                children.remove(children.iterator().next());
            }
            return children;
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException("Getting axis values failure", (Throwable)e);
        }
    }

    public List<NodeDetail> getAxisHeaders(String componentId) {
        try {
            return this.getNodeService().getHeadersByLevel(new NodePK("useless", componentId), 2);
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException((Throwable)e);
        }
    }

    public NodeDetail addPosition(NodeDetail position, String axisId, String componentId) {
        position.getNodePK().setComponentName(componentId);
        position.setCreationDate(new Date());
        try {
            NodeDetail fatherDetail = this.getNodeHeader(axisId, componentId);
            return this.getNodeService().createNode(position, fatherDetail);
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException("Adding position failure", (Throwable)e);
        }
    }

    public NodeDetail getNodeHeader(NodePK pk) {
        try {
            return this.getNodeService().getHeader(pk);
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException((Throwable)e);
        }
    }

    public NodeDetail getNodeHeader(String id, String componentId) {
        NodePK pk = new NodePK(id, componentId);
        return this.getNodeHeader(pk);
    }

    private CoordinatesService getCoordinatesService() {
        return this.coordinatesService;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }

    public List<String> coupleIds(List<String> filesNames, List<String> nodeIds, int cur, int loop, int nTuple, String prefixeId, int nbAxis) {
        for (int i = cur; i < nodeIds.size(); ++i) {
            String terme = nodeIds.get(i);
            String tmp = prefixeId == null ? terme : prefixeId + "-" + terme;
            if (loop < nTuple - 1) {
                this.coupleIds(filesNames, nodeIds, i + 1, loop + 1, nTuple, tmp, nbAxis);
                continue;
            }
            String positionNameId = "index-" + tmp + ".html";
            StringTokenizer st = new StringTokenizer(positionNameId, "-");
            if (st.countTokens() - 1 != nbAxis) continue;
            filesNames.add(positionNameId);
        }
        return filesNames;
    }
}

