/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.importexport.control.ImportSettings;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.mail.extractor.Extractor;
import org.silverpeas.core.mail.extractor.Mail;
import org.silverpeas.core.mail.extractor.MailExtractor;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class PublicationImportExport {
    static final LocalizationBundle multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.importExport.multilang.importExportBundle");

    private PublicationImportExport() {
    }

    public static PublicationDetail convertFileInfoToPublicationDetail(File file, ImportSettings settings) {
        String fileName = file.getName();
        String nomPub = settings.getPublicationName(fileName);
        Object description = "";
        String motsClefs = "";
        String content = "";
        Date creationDate = new Date();
        Date lastModificationDate = null;
        if (!settings.mustCreateOnePublicationForAllFiles()) {
            if (FileUtil.isMail((String)file.getName())) {
                try {
                    MailExtractor extractor = Extractor.getExtractor((File)file);
                    Mail mail = extractor.getMail();
                    creationDate = mail.getDate();
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("subject", mail.getSubject());
                    InternetAddress address = mail.getFrom();
                    if (StringUtil.isDefined((String)address.getPersonal())) {
                        attributes.put("fromPersonal", address.getPersonal());
                        description = (String)description + address.getPersonal() + " - ";
                    }
                    attributes.put("fromAddress", address.getAddress());
                    SilverpeasTemplate template = SilverpeasTemplates.createSilverpeasTemplateOnComponents();
                    attributes.forEach((arg_0, arg_1) -> ((SilverpeasTemplate)template).setAttribute(arg_0, arg_1));
                    nomPub = template.applyStringTemplate(multilang.getString("importExport.import.mail.title"));
                    description = template.applyStringTemplate(multilang.getString("importExport.import.mail.description"));
                }
                catch (Exception e) {
                    SilverLogger.getLogger(PublicationImportExport.class).error((Throwable)e);
                }
            } else {
                MetaData metaData = null;
                if (settings.isPoiUsed()) {
                    metaData = MetadataExtractor.get().extractMetadata(file.getAbsolutePath());
                    if (StringUtil.isDefined((String)metaData.getTitle())) {
                        nomPub = metaData.getTitle();
                    }
                    if (StringUtil.isDefined((String)metaData.getSubject())) {
                        description = metaData.getSubject();
                    }
                    if (metaData.getKeywords() != null && metaData.getKeywords().length > 0) {
                        motsClefs = StringUtils.join((Object[])metaData.getKeywords(), (char)';');
                    }
                }
                if (settings.useFileDates()) {
                    if (metaData == null) {
                        metaData = MetadataExtractor.get().extractMetadata(file.getAbsolutePath());
                    }
                    if (metaData.getCreationDate() != null) {
                        creationDate = metaData.getCreationDate();
                    }
                    if (metaData.getLastSaveDateTime() != null) {
                        lastModificationDate = metaData.getLastSaveDateTime();
                    }
                }
            }
        } else {
            nomPub = settings.getPublicationForAllFiles().getName();
            description = settings.getPublicationForAllFiles().getDescription();
            motsClefs = settings.getPublicationForAllFiles().getKeywords();
            content = settings.getPublicationForAllFiles().getContentPagePath();
        }
        PublicationDetail publication = PublicationDetail.builder((String)settings.getContentLanguage()).setNameAndDescription(nomPub, (String)description).created(creationDate, settings.getUser().getId()).setBeginDateTime(new Date(), null).setImportance(1).setKeywords(motsClefs).setContentPagePath(content).build();
        publication.setTargetValidatorId(settings.getTargetValidatorIds());
        if (lastModificationDate != null) {
            publication.setUpdateDate(lastModificationDate);
            publication.setUpdateDataMustBeSet(true);
        }
        return publication;
    }

    public static void addNodesToPublication(PublicationPK pubPK, List<Integer> nodes) {
        for (Integer coordinateId : nodes) {
            PublicationImportExport.getPublicationService().addFather(pubPK, new NodePK(coordinateId.toString(), (ResourceReference)pubPK));
        }
    }

    private static PublicationService getPublicationService() {
        return PublicationService.get();
    }

    public static List<PublicationDetail> getUnbalancedPublications(String componentId) {
        return new ArrayList<PublicationDetail>(PublicationImportExport.getPublicationService().getOrphanPublications(componentId));
    }
}

