/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.tree.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderI18N;
import org.silverpeas.core.pdc.tree.model.TreeNodeI18N;
import org.silverpeas.core.pdc.tree.model.TreeNodePK;
import org.silverpeas.core.pdc.tree.model.TreeNodePersistence;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TreeNode
extends AbstractI18NBean<TreeNodeI18N>
implements Serializable {
    private static final long serialVersionUID = 4644891370102942728L;
    private TreeNodePK pk = new TreeNodePK("0");
    private String treeId = "0";
    private String creationDate = "";
    private String creatorId = "";
    @XmlAttribute(name="pdcValuePath")
    private String path = "";
    private int levelNumber = 0;
    private int orderNumber = 0;
    private String fatherId = "0";

    protected Class<TreeNodeI18N> getTranslationType() {
        return TreeNodeI18N.class;
    }

    public TreeNode() {
        this.setName("");
        this.setDescription("");
    }

    public TreeNode(String id, String treeId) {
        this.setPK(new TreeNodePK(id));
        this.treeId = treeId;
    }

    public TreeNode(TreeNodePersistence persistence) {
        this.pk = new TreeNodePK(persistence.getPK());
        this.treeId = persistence.getTreeId();
        this.setName(persistence.getName());
        this.setDescription(persistence.getDescription());
        this.creationDate = persistence.getCreationDate();
        this.creatorId = persistence.getCreatorId();
        this.path = persistence.getPath();
        this.levelNumber = persistence.getLevelNumber();
        this.orderNumber = persistence.getOrderNumber();
        this.fatherId = persistence.getFatherId();
        this.setLanguage(persistence.getLang());
    }

    public TreeNodePK getPK() {
        return this.pk;
    }

    public void setPK(TreeNodePK value) {
        this.pk = value;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getPath() {
        return this.path;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public boolean hasFather() {
        return StringUtil.isDefined((String)this.getFatherId()) && !"-1".equals(this.getFatherId());
    }

    public void setCreationDate(String date) {
        this.creationDate = date;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setFatherId(String fatherId) {
        this.fatherId = fatherId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLevelNumber(int levelNumber) {
        this.levelNumber = levelNumber;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setTranslationsFrom(Map<String, AxisHeaderI18N> translations) {
        HashMap<String, TreeNodeI18N> treeNodeTranslations = new HashMap<String, TreeNodeI18N>();
        for (Map.Entry<String, AxisHeaderI18N> entry : translations.entrySet()) {
            treeNodeTranslations.put(entry.getKey(), new TreeNodeI18N(entry.getValue()));
        }
        this.setTranslations(treeNodeTranslations);
    }
}

