/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.subscription.service;

import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.pdc.subscription.model.PdcSubscription;
import org.silverpeas.core.pdc.subscription.service.AbstractPdcSubscriptionUserNotification;
import org.silverpeas.kernel.bundle.LocalizationBundle;

public class PdcSubscriptionDeletionUserNotification
extends AbstractPdcSubscriptionUserNotification<PdcSubscription> {
    private static final String MESSAGE_DELETE_TITLE = "notification.delete.title";
    private static final String SOURCE_CLASSIFICATION = "pdcClassification";
    boolean valueDeleted = false;
    String axisName = null;

    public PdcSubscriptionDeletionUserNotification(PdcSubscription pdcSubscription, String axisName, boolean valueDeleted) {
        super(pdcSubscription, pdcSubscription);
        this.valueDeleted = valueDeleted;
        this.axisName = axisName;
    }

    protected NotifAction getAction() {
        return NotifAction.DELETE;
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected String getComponentInstanceId() {
        return null;
    }

    protected String getSender() {
        return "";
    }

    protected void performBuild(PdcSubscription subscription) {
        String lang = this.getUserLanguage(subscription.getOwnerId());
        LocalizationBundle resources = this.getBundle(lang);
        StringBuilder message = new StringBuilder(150);
        if (this.valueDeleted) {
            message.append(resources.getString("deleteOnValueMessage"));
        } else {
            message.append(resources.getString("deleteOnAxisMessage"));
        }
        message.append("\n");
        message.append(resources.getString("Subscription"));
        message.append(subscription.getName());
        message.append("\n");
        message.append(resources.getString("Axis"));
        message.append(this.axisName);
        message.append("\n");
        this.getNotificationMetaData().setTitle(resources.getString(MESSAGE_DELETE_TITLE));
        this.getNotificationMetaData().setContent(message.toString());
        this.getNotificationMetaData().setSource(resources.getString(SOURCE_CLASSIFICATION));
    }

    protected void performNotificationResource(PdcSubscription resource, NotificationResourceData notificationResourceData) {
    }
}

