/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.subscription.service;

import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.pdc.subscription.model.PdcSubscription;
import org.silverpeas.core.pdc.subscription.service.AbstractPdcSubscriptionUserNotification;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.util.StringUtil;

public class PdcResourceClassificationUserNotification
extends AbstractPdcSubscriptionUserNotification<SilverContentInterface>
implements UserSubscriptionNotificationBehavior {
    public PdcResourceClassificationUserNotification(PdcSubscription pdcSubscription, SilverContentInterface silverContent) {
        super(pdcSubscription, silverContent);
    }

    protected NotifAction getAction() {
        return NotifAction.CLASSIFIED;
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected String getComponentInstanceId() {
        return ((SilverContentInterface)this.getResource()).getInstanceId();
    }

    protected String getSender() {
        return ((SilverContentInterface)this.getResource()).getCreatorId();
    }

    protected void performBuild(SilverContentInterface silverContent) {
        String lang = this.getUserLanguage(this.getPdcSubscription().getOwnerId());
        LocalizationBundle resources = this.getBundle(lang);
        StringBuilder message = new StringBuilder(150);
        message.append(resources.getString("Subscription"));
        message.append(this.getPdcSubscription().getName());
        message.append("\n");
        message.append(resources.getString("DocumentName"));
        message.append(silverContent.getName(lang));
        message.append("\n");
        this.getNotificationMetaData().setTitle(resources.getString("standartMessage"));
        this.getNotificationMetaData().setContent(message.toString());
    }

    protected void performNotificationResource(SilverContentInterface silverContent, NotificationResourceData notificationResourceData) {
        if (notificationResourceData.getResourceId() == null) {
            notificationResourceData.setResourceId(silverContent.getId());
            notificationResourceData.setResourceType("PDCSubscriptionUnknownResourceType");
        }
        String lang = this.getUserLanguage(this.getPdcSubscription().getOwnerId());
        notificationResourceData.setResourceName(silverContent.getName(lang));
        notificationResourceData.setResourceDescription(silverContent.getDescription(lang));
    }

    protected String getResourceURL(SilverContentInterface silverContent) {
        return StringUtil.defaultStringIfNotDefined((String)URLUtil.getSearchResultURL((Contribution)silverContent), null);
    }
}

