/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContent;
import org.silverpeas.core.index.search.SearchQueryProcessor;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.index.search.model.SearchResult;
import org.silverpeas.core.index.search.qualifiers.TaxonomySearch;
import org.silverpeas.core.pdc.pdc.model.AxisValueCriterion;
import org.silverpeas.core.pdc.pdc.model.SearchContext;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@TaxonomySearch
public class PdcSearchProcessor
implements SearchQueryProcessor {
    @Inject
    private PdcManager pdcManager;
    private final Comparator<GlobalSilverContent> cDateDesc = (o1, o2) -> {
        Date creationDate1 = o1.getCreationDate();
        Date creationDate2 = o2.getCreationDate();
        if (creationDate1 != null && creationDate2 != null) {
            int result = creationDate2.compareTo(creationDate1);
            return result != 0 ? result : o2.getId().compareTo(o1.getId());
        }
        return 1;
    };

    public List<SearchResult> process(QueryDescription query, List<SearchResult> results) {
        SearchContext pdcContext = new SearchContext(query.getSearchingUser());
        AxisValueCriterion.fromFlattenedAxisValues(query.getTaxonomyPosition()).forEach(pdcContext::addCriteria);
        if (!pdcContext.isEmpty()) {
            try {
                List<Integer> contentIds = this.pdcManager.findSilverContentIdByPosition(pdcContext, new ArrayList<String>(query.getWhereToSearch()), null, query.getRequestedCreatedAfter(), query.getRequestedCreatedBefore());
                return this.pdcManager.getSilverContentsByIds(contentIds, pdcContext.getUserId()).stream().sorted(this.cDateDesc).map(SearchResult::fromGlobalSilverContent).collect(Collectors.toList());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Error during taxonomy search by user {0}", (Object[])new String[]{User.getById((String)pdcContext.getUserId()).getDisplayedName()}, (Throwable)e);
            }
        }
        return new ArrayList<SearchResult>();
    }
}

