/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.pdc.pdc.model.SearchCriteria;

public class SearchContext
implements Serializable {
    private static final long serialVersionUID = 3377353406396353627L;
    private ArrayList<SearchCriteria> criterias = new ArrayList();
    private String userId = null;

    public SearchContext(String userId) {
        this.userId = userId;
    }

    public List<SearchCriteria> getCriterias() {
        return this.criterias;
    }

    public void addCriteria(SearchCriteria criteria) {
        SearchCriteria existingCriteriaOnAxis;
        if (this.criterias == null) {
            this.criterias = new ArrayList();
        }
        if ((existingCriteriaOnAxis = this.getCriteriaOnAxis(criteria.getAxisId())) != null) {
            this.removeCriteria(existingCriteriaOnAxis);
        }
        this.criterias.add(criteria);
    }

    public void clearCriterias() {
        this.criterias = new ArrayList();
    }

    public void removeCriteria(SearchCriteria criteria) {
        if (this.criterias != null) {
            this.criterias.remove(criteria);
        }
    }

    public void removeCriteria(int axisId) {
        SearchCriteria criteria = this.getCriteriaOnAxis(axisId);
        if (criteria != null) {
            this.removeCriteria(criteria);
        }
    }

    public boolean isEmpty() {
        return this.criterias.size() == 0;
    }

    public SearchCriteria getCriteriaOnAxis(int axisId) {
        SearchCriteria criteria = null;
        for (int c = 0; this.criterias != null && c < this.criterias.size(); ++c) {
            criteria = this.criterias.get(c);
            if (criteria.getAxisId() != axisId) continue;
            return criteria;
        }
        return null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

