/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.DeclaredMembershipPredicate;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.security.user.query.Condition;
import org.apache.jackrabbit.oak.security.user.query.GroupPredicate;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.security.user.query.ResultIterator;
import org.apache.jackrabbit.oak.security.user.query.ResultRowToAuthorizable;
import org.apache.jackrabbit.oak.security.user.query.XPathConditionVisitor;
import org.apache.jackrabbit.oak.security.user.query.XPathQueryBuilder;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserQueryManager {
    private static final Logger log = LoggerFactory.getLogger(UserQueryManager.class);
    private final UserManagerImpl userManager;
    private final NamePathMapper namePathMapper;
    private final ConfigurationParameters config;
    private final Root root;

    public UserQueryManager(@NotNull UserManagerImpl userManager, @NotNull NamePathMapper namePathMapper, @NotNull ConfigurationParameters config, @NotNull Root root) {
        this.userManager = userManager;
        this.namePathMapper = namePathMapper;
        this.config = config;
        this.root = root;
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull Query query) throws RepositoryException {
        XPathQueryBuilder builder = new XPathQueryBuilder();
        query.build((QueryBuilder)builder);
        if (builder.getMaxCount() == 0L) {
            return Collections.emptyIterator();
        }
        String statement = this.buildXPathStatement(builder);
        String groupId = builder.getGroupID();
        if (groupId == null || this.isEveryone(groupId)) {
            long offset = builder.getOffset();
            Iterator<Authorizable> result = this.findAuthorizables(statement, builder.getMaxCount(), offset, null);
            if (groupId == null) {
                return result;
            }
            return IteratorUtils.filter(result, authorizable -> !groupId.equals(QueryUtil.getID(authorizable)));
        }
        Iterator<Authorizable> result = this.findAuthorizables(statement, Long.MAX_VALUE, 0L, null);
        Predicate<Authorizable> filter = builder.isDeclaredMembersOnly() ? new DeclaredMembershipPredicate(this.userManager, groupId) : new GroupPredicate(this.userManager, groupId, false);
        return ResultIterator.create(builder.getOffset(), builder.getMaxCount(), IteratorUtils.filter(result, filter::test));
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value, @NotNull AuthorizableType authorizableType) throws RepositoryException {
        return this.findAuthorizables(relPath, value, authorizableType, true);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value, @NotNull AuthorizableType authorizableType, boolean exact) throws RepositoryException {
        String statement = this.buildXPathStatement(relPath, value, authorizableType, exact);
        return this.findAuthorizables(statement, Long.MAX_VALUE, 0L, authorizableType);
    }

    @NotNull
    private String buildXPathStatement(@NotNull String relPath, @Nullable String value, @NotNull AuthorizableType type, boolean exact) {
        String ntName;
        String path;
        String searchRoot = this.namePathMapper.getJcrPath(QueryUtil.getSearchRoot(type, this.config));
        StringBuilder stmt = new StringBuilder().append(searchRoot);
        String propName = Text.getName((String)relPath);
        if (relPath.indexOf(47) == -1 && !UserQueryManager.isReserved(propName)) {
            path = null;
            ntName = null;
        } else {
            path = UserQueryManager.getQueryPath(relPath);
            ntName = path == null ? this.namePathMapper.getJcrName(QueryUtil.getNodeTypeName(type)) : null;
        }
        stmt.append("//");
        if (path != null) {
            stmt.append(path);
        } else if (ntName != null) {
            stmt.append("element(*,").append(ntName).append(')');
        } else {
            stmt.append("element(*)");
        }
        if (value == null) {
            stmt.append("[@").append(propName).append(']');
        } else {
            stmt.append('[');
            stmt.append(exact ? "@" : "jcr:like(@");
            stmt.append(ISO9075.encode((String)propName));
            if (exact) {
                stmt.append("='");
                stmt.append(value.replace("'", "''"));
                stmt.append('\'');
            } else {
                stmt.append(",'%");
                stmt.append(QueryUtil.escapeForQuery(value));
                stmt.append("%')");
            }
            stmt.append(']');
        }
        return stmt.toString();
    }

    @NotNull
    private String buildXPathStatement(@NotNull XPathQueryBuilder builder) throws RepositoryException {
        Condition condition = builder.getCondition();
        String sortCol = builder.getSortProperty();
        QueryBuilder.Direction sortDir = builder.getSortDirection();
        Value bound = builder.getBound();
        if (bound != null) {
            if (sortCol == null) {
                log.warn("Ignoring bound {} since no sort order is specified", (Object)bound);
            } else {
                Condition boundCondition = builder.property(sortCol, QueryUtil.getCollation(sortDir), bound);
                condition = condition == null ? boundCondition : builder.and(condition, boundCondition);
            }
        }
        StringBuilder statement = new StringBuilder();
        String searchRoot = this.namePathMapper.getJcrPath(QueryUtil.getSearchRoot(builder.getSelectorType(), this.config));
        String ntName = this.namePathMapper.getJcrName(QueryUtil.getNodeTypeName(builder.getSelectorType()));
        statement.append(searchRoot).append("//element(*,").append(ntName).append(')');
        if (condition != null) {
            XPathConditionVisitor visitor = new XPathConditionVisitor(statement, this.namePathMapper, this.userManager);
            statement.append('[');
            condition.accept(visitor);
            statement.append(']');
        }
        if (sortCol != null) {
            boolean ignoreCase = builder.getSortIgnoreCase();
            statement.append(" order by ");
            if (ignoreCase) {
                statement.append("fn:lower-case(").append(sortCol).append(')');
            } else {
                statement.append(sortCol);
            }
            statement.append(' ').append(sortDir.getDirection());
        }
        return statement.toString();
    }

    @NotNull
    private Iterator<Authorizable> findAuthorizables(@NotNull String statement, long limit, long offset, @Nullable AuthorizableType type) throws RepositoryException {
        try {
            Result query = this.root.getQueryEngine().executeQuery(statement, "xpath", limit, offset, QueryEngine.NO_BINDINGS, this.namePathMapper.getSessionLocalMappings());
            Iterable resultRows = query.getRows();
            Iterator authorizables = IteratorUtils.transform(resultRows.iterator(), new ResultRowToAuthorizable(this.userManager, this.root, type, query.getSelectorNames())::apply);
            return IteratorUtils.filter((Iterator)authorizables, new UniqueResultPredicate()::test);
        }
        catch (ParseException e) {
            throw new RepositoryException("Invalid user query " + statement, (Throwable)e);
        }
    }

    @Nullable
    private static String getQueryPath(@NotNull String relPath) {
        if (relPath.indexOf(47) == -1) {
            return null;
        }
        String[] segments = Text.explode((String)relPath, (int)47, (boolean)false);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < segments.length - 1; ++i) {
            if (PathUtils.denotesCurrent((String)segments[i])) continue;
            if (i > 0) {
                sb.append('/');
            }
            sb.append(segments[i]);
        }
        return StringUtils.emptyToNull((String)sb.toString());
    }

    private static boolean isReserved(@NotNull String propName) {
        return UserConstants.GROUP_PROPERTY_NAMES.contains(propName) || UserConstants.USER_PROPERTY_NAMES.contains(propName);
    }

    private boolean isEveryone(@NotNull String groupId) throws RepositoryException {
        Group gr = this.userManager.getAuthorizable(groupId, Group.class);
        if (gr == null) {
            return "everyone".equals(groupId);
        }
        return "everyone".equals(gr.getPrincipal().getName());
    }

    private static final class UniqueResultPredicate
    implements Predicate<Authorizable> {
        private final Set<String> authorizableIds = new HashSet<String>();

        private UniqueResultPredicate() {
        }

        @Override
        public boolean test(@Nullable Authorizable input) {
            String id = QueryUtil.getID(input);
            return id != null && this.authorizableIds.add(id);
        }
    }
}

