/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class DescendantNodeImpl
extends ConstraintImpl {
    private final String selectorName;
    private final String ancestorPath;
    private SelectorImpl selector;

    public DescendantNodeImpl(String selectorName, String ancestorPath) {
        this.selectorName = selectorName;
        this.ancestorPath = ancestorPath;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public boolean evaluate() {
        if (this.selector.isVirtualRow()) {
            return true;
        }
        String p = this.selector.currentPath();
        if (p == null) {
            return false;
        }
        String path = this.normalizePath(this.ancestorPath);
        if (path == null) {
            return false;
        }
        return PathUtils.isAncestor((String)path, (String)p);
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "isdescendantnode(" + DescendantNodeImpl.quote(this.selectorName) + ", " + DescendantNodeImpl.quote(this.ancestorPath) + ")";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector)) {
            String path = this.normalizePath(this.ancestorPath);
            f.restrictPath(path, Filter.PathRestriction.ALL_CHILDREN);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public AstElement copyOf() {
        return new DescendantNodeImpl(this.selectorName, this.ancestorPath);
    }
}

