/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractTypeDefinition {
    private static final String[] NO_STRINGS = new String[0];
    protected final Tree definition;
    protected final NamePathMapper mapper;

    protected AbstractTypeDefinition(Tree definition, NamePathMapper mapper) {
        this.definition = Objects.requireNonNull(definition);
        this.mapper = Objects.requireNonNull(mapper);
    }

    protected boolean getBoolean(@NotNull String name) {
        PropertyState property = this.definition.getProperty(Objects.requireNonNull(name));
        return property != null && (Boolean)property.getValue(Type.BOOLEAN) != false;
    }

    @Nullable
    protected String getString(@NotNull String oakName) {
        return this.getValue(oakName, (Type<String>)Type.STRING);
    }

    @Nullable
    protected String[] getStrings(@NotNull String oakName) {
        return this.getValues(oakName, (Type<String>)Type.STRING);
    }

    @Nullable
    protected String getName(@NotNull String oakName) {
        return this.getValue(oakName, (Type<String>)Type.NAME);
    }

    @Nullable
    protected String[] getNames(@NotNull String oakName) {
        return this.getValues(oakName, (Type<String>)Type.NAME);
    }

    private String getValue(String oakName, Type<String> type) {
        PropertyState property = this.definition.getProperty(Objects.requireNonNull(oakName));
        if (property != null) {
            return (String)property.getValue(type);
        }
        return null;
    }

    private String[] getValues(String oakName, Type<String> type) {
        String[] values = null;
        PropertyState property = this.definition.getProperty(Objects.requireNonNull(oakName));
        if (property != null) {
            int n = property.count();
            if (n > 0) {
                values = new String[n];
                for (int i = 0; i < n; ++i) {
                    values[i] = (String)property.getValue(type, i);
                }
            } else {
                values = NO_STRINGS;
            }
        }
        return values;
    }
}

