/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;

public class IndexMBeanRegistration
implements Registration {
    private final Whiteboard whiteboard;
    private final List<Registration> regs = new ArrayList<Registration>();

    public IndexMBeanRegistration(Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
    }

    public void registerAsyncIndexer(AsyncIndexUpdate task, long delayInSeconds) {
        task.setIndexMBeanRegistration(this);
        Map<String, CallSite> config = Map.of("oak.async", task.getName(), "scheduler.name", AsyncIndexUpdate.class.getName() + "-" + task.getName());
        this.regs.add(WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)this.whiteboard, (Runnable)task, config, (long)delayInSeconds, (WhiteboardUtils.ScheduleExecutionInstanceTypes)WhiteboardUtils.ScheduleExecutionInstanceTypes.RUN_ON_LEADER, (boolean)true));
        this.regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, IndexStatsMBean.class, (Object)((Object)task.getIndexStats()), (String)"IndexStats", (String)task.getName()));
    }

    public void unregister() {
        new CompositeRegistration(this.regs).unregister();
    }
}

