/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.guava.common.base.Splitter;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.plugins.commit.AnnotatingConflictHandler;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexCommitCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.TrackingCorruptIndexHandler;
import org.apache.jackrabbit.oak.plugins.index.progress.MetricRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.NodeCounterMBeanEstimator;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.Counting;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncIndexUpdate
implements Runnable,
Closeable {
    public static final String PROP_ASYNC_NAME = "oak.async";
    private static final String CONCURRENT_EXCEPTION_MSG = "The index was not updated. Waiting for the lease to expire (another copy might be still running); skipping this update. ";
    private static final Logger log = LoggerFactory.getLogger(AsyncIndexUpdate.class);
    static final String ASYNC = ":async";
    private static final long DEFAULT_LIFETIME = TimeUnit.DAYS.toMillis(100L);
    private static final CommitFailedException INTERRUPTED = new CommitFailedException("Async", 1, "Indexing stopped forcefully");
    private static final long DEFAULT_ASYNC_TIMEOUT = TimeUnit.MINUTES.toMillis(Integer.getInteger("oak.async.lease.timeout", 15).intValue());
    private final String name;
    private final NodeStore store;
    private final IndexEditorProvider provider;
    private final String lastIndexedTo;
    private final long lifetime = DEFAULT_LIFETIME;
    private final AsyncIndexStats indexStats;
    private final boolean switchOnSync;
    private final Set<String> reindexedDefinitions = new HashSet<String>();
    private final IndexUpdate.MissingIndexProviderStrategy missingStrategy = new DefaultMissingIndexProviderStrategy();
    private final IndexTaskSpliter taskSplitter = new IndexTaskSpliter();
    private final Semaphore runPermit = new Semaphore(1);
    private final AtomicBoolean forcedStopFlag = new AtomicBoolean();
    private IndexMBeanRegistration mbeanRegistration;
    private long leaseTimeOut;
    private static long ERROR_WARN_INTERVAL = TimeUnit.MINUTES.toMillis(Integer.getInteger("oak.async.warn.interval", 30).intValue());
    private int softTimeOutSecs = Integer.getInteger("oak.async.softTimeOutSecs", 120);
    private boolean closed;
    private final int cleanupIntervalMinutes = Integer.getInteger("oak.async.checkpointCleanupIntervalMinutes", 5);
    private final boolean traverseNodesIfLaneNotPresentInIndex = !Boolean.getBoolean("oak.async.traverseNodesIfLanePresentInIndex");
    private long lastCheckpointCleanUpTime;
    private List<ValidatorProvider> validatorProviders = Collections.emptyList();
    private TrackingCorruptIndexHandler corruptIndexHandler = new TrackingCorruptIndexHandler();
    private final StatisticsProvider statisticsProvider;

    public AsyncIndexUpdate(@NotNull String name, @NotNull NodeStore store, @NotNull IndexEditorProvider provider, boolean switchOnSync) {
        this(name, store, provider, StatisticsProvider.NOOP, switchOnSync);
    }

    public AsyncIndexUpdate(@NotNull String name, @NotNull NodeStore store, @NotNull IndexEditorProvider provider, StatisticsProvider statsProvider, boolean switchOnSync) {
        this.name = AsyncIndexUpdate.checkValidName(name);
        this.lastIndexedTo = AsyncIndexUpdate.lastIndexedTo(name);
        this.store = Objects.requireNonNull(store);
        this.provider = Objects.requireNonNull(provider);
        this.switchOnSync = switchOnSync;
        this.leaseTimeOut = DEFAULT_ASYNC_TIMEOUT;
        this.statisticsProvider = statsProvider;
        this.indexStats = new AsyncIndexStats(name, statsProvider);
        this.corruptIndexHandler.setMeterStats(statsProvider.getMeter("corrupt-index", StatsOptions.METRICS_ONLY));
    }

    public AsyncIndexUpdate(@NotNull String name, @NotNull NodeStore store, @NotNull IndexEditorProvider provider) {
        this(name, store, provider, false);
    }

    public static String checkValidName(String asyncName) {
        Objects.requireNonNull(asyncName, "async name should not be null");
        if ("async-reindex".equals(asyncName)) {
            return asyncName;
        }
        Validate.checkArgument((boolean)asyncName.endsWith("async"), (String)"async name [%s] does not confirm to naming pattern of ending with 'async'", (Object[])new Object[]{asyncName});
        return asyncName;
    }

    public static boolean isAsyncLaneName(String asyncName) {
        return "async-reindex".equals(asyncName) || asyncName.endsWith("async");
    }

    @Override
    public synchronized void run() {
        if (!this.shouldProceed()) {
            return;
        }
        boolean permitAcquired = false;
        try {
            if (this.runPermit.tryAcquire()) {
                permitAcquired = true;
                this.runWhenPermitted();
            } else {
                log.warn("[{}] Could not acquire run permit. Stop flag set to [{}] Skipping the run", (Object)this.name, (Object)this.forcedStopFlag);
            }
        }
        finally {
            if (permitAcquired) {
                this.runPermit.release();
            }
        }
    }

    @Override
    public void close() {
        block7: {
            if (this.closed) {
                return;
            }
            int hardTimeOut = 5 * this.softTimeOutSecs;
            if (!this.runPermit.tryAcquire()) {
                log.debug("[{}] [WAITING] Indexing in progress. Would wait for {} secs for it to finish", (Object)this.name, (Object)this.softTimeOutSecs);
                try {
                    if (!this.runPermit.tryAcquire(this.softTimeOutSecs, TimeUnit.SECONDS)) {
                        log.debug("[{}] [SOFT LIMIT HIT] Indexing found to be in progress for more than [{}]s. Would signal it to now force stop", (Object)this.name, (Object)this.softTimeOutSecs);
                        this.forcedStopFlag.set(true);
                        if (!this.runPermit.tryAcquire(hardTimeOut, TimeUnit.SECONDS)) {
                            log.warn("[{}] Indexing still not found to be complete. Giving up after [{}]s", (Object)this.name, (Object)hardTimeOut);
                        }
                        break block7;
                    }
                    log.info("[{}] [CLOSED OK] Async indexing run completed. Closing it now", (Object)this.name);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                log.info("[{}] Closed", (Object)this.name);
            }
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWhenPermitted() {
        NodeState before;
        long currentTime;
        long leaseEndTime;
        if (this.indexStats.isPaused()) {
            if (this.indexStats.forcedLeaseRelease) {
                try {
                    this.clearLease();
                }
                catch (CommitFailedException e) {
                    log.warn("Unable to release lease, please try again", (Throwable)e);
                }
                this.indexStats.forcedLeaseRelease = false;
            }
            log.debug("[{}] Ignoring the run as indexing is paused", (Object)this.name);
            return;
        }
        log.debug("[{}] Running background index task", (Object)this.name);
        NodeState root = this.store.getRoot();
        NodeState async = root.getChildNode(ASYNC);
        if (AsyncIndexUpdate.isLeaseCheckEnabled(this.leaseTimeOut) && (leaseEndTime = async.getLong(AsyncIndexUpdate.leasify(this.name))) > (currentTime = System.currentTimeMillis())) {
            long leaseExpMsg = (leaseEndTime - currentTime) / 1000L;
            String err = String.format("The index was not updated. Waiting for the lease to expire (another copy might be still running); skipping this update. Time left for lease to expire %d s. Indexing can resume by %tT", leaseExpMsg, leaseEndTime);
            this.indexStats.failed(new Exception(err, AsyncIndexUpdate.newConcurrentUpdateException()));
            return;
        }
        AsyncIndexUpdate.preAsyncRunStatsStats(this.indexStats);
        String beforeCheckpoint = async.getString(this.name);
        AsyncUpdateCallback callback = this.newAsyncUpdateCallback(this.store, this.name, this.leaseTimeOut, beforeCheckpoint, this.indexStats, this.forcedStopFlag);
        if (beforeCheckpoint != null) {
            NodeState state = this.store.retrieve(beforeCheckpoint);
            if (state == null) {
                try {
                    callback.initLease();
                }
                catch (CommitFailedException e) {
                    this.indexStats.failed((Exception)((Object)e));
                    return;
                }
                root = this.store.getRoot();
                beforeCheckpoint = root.getChildNode(ASYNC).getString(this.name);
                if (beforeCheckpoint != null) {
                    state = this.store.retrieve(beforeCheckpoint);
                    callback.setCheckpoint(beforeCheckpoint);
                }
            }
            if (state == null) {
                log.warn("[{}] Failed to retrieve previously indexed checkpoint {}; re-running the initial index update", (Object)this.name, (Object)beforeCheckpoint);
                beforeCheckpoint = null;
                callback.setCheckpoint(beforeCheckpoint);
                before = EmptyNodeState.MISSING_NODE;
            } else {
                if (AsyncIndexUpdate.noVisibleChanges(state, root) && !this.switchOnSync) {
                    log.debug("[{}] No changes since last checkpoint; skipping the index update", (Object)this.name);
                    AsyncIndexUpdate.postAsyncRunStatsStatus(this.indexStats);
                    return;
                }
                before = state;
            }
        } else {
            log.info("[{}] Initial index update", (Object)this.name);
            before = EmptyNodeState.MISSING_NODE;
        }
        String afterTime = AsyncIndexUpdate.now();
        String oldThreadName = Thread.currentThread().getName();
        boolean threadNameChanged = false;
        String afterCheckpoint = this.store.checkpoint(this.lifetime, Map.of("creator", AsyncIndexUpdate.class.getSimpleName(), "created", afterTime, "thread", oldThreadName, "name", this.name));
        NodeState after = this.store.retrieve(afterCheckpoint);
        if (after == null) {
            log.debug("[{}] Unable to retrieve newly created checkpoint {}, skipping the index update", (Object)this.name, (Object)afterCheckpoint);
            return;
        }
        AtomicReference<String> checkpointToReleaseRef = new AtomicReference<String>(afterCheckpoint);
        boolean updatePostRunStatus = false;
        try {
            String newThreadName = "async-index-update-" + this.name;
            log.trace("Switching thread name to {}", (Object)newThreadName);
            threadNameChanged = true;
            Thread.currentThread().setName(newThreadName);
            updatePostRunStatus = this.updateIndex(before, beforeCheckpoint, after, afterCheckpoint, afterTime, callback, checkpointToReleaseRef);
            if (this.indexStats.didLastIndexingCycleFailed()) {
                this.indexStats.fixed();
            }
            checkpointToReleaseRef.set(beforeCheckpoint);
            this.indexStats.setReferenceCheckpoint(afterCheckpoint);
            this.indexStats.setProcessedCheckpoint("");
            this.indexStats.releaseTempCheckpoint(afterCheckpoint);
        }
        catch (Exception e) {
            this.indexStats.failed(e);
        }
        finally {
            String checkpointToRelease;
            if (threadNameChanged) {
                log.trace("Switching thread name back to {}", (Object)oldThreadName);
                Thread.currentThread().setName(oldThreadName);
            }
            if ((checkpointToRelease = checkpointToReleaseRef.get()) != null && !checkpointToRelease.equals(this.taskSplitter.getLastReferencedCp()) && !this.store.release(checkpointToRelease)) {
                log.debug("[{}] Unable to release checkpoint {}", (Object)this.name, (Object)checkpointToRelease);
            }
            this.maybeCleanUpCheckpoints();
            if (updatePostRunStatus) {
                AsyncIndexUpdate.postAsyncRunStatsStatus(this.indexStats);
            }
        }
    }

    private void clearLease() throws CommitFailedException {
        NodeState root = this.store.getRoot();
        NodeState async = root.getChildNode(ASYNC);
        String beforeCheckpoint = async.getString(this.name);
        String leaseName = AsyncIndexUpdate.leasify(this.name);
        if (async.hasProperty(leaseName)) {
            NodeBuilder builder = root.builder();
            builder.child(ASYNC).removeProperty(leaseName);
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, beforeCheckpoint, null, this.name);
            log.info("Lease property removed for lane: {}", (Object)this.name);
        } else {
            log.info("No Lease property present for lane: {}", (Object)this.name);
        }
    }

    private boolean shouldProceed() {
        NodeState asyncNode = this.store.getRoot().getChildNode(ASYNC);
        if (asyncNode.exists() && asyncNode.hasProperty(this.name)) {
            return true;
        }
        return this.traverseNodesIfLaneNotPresentInIndex || this.isIndexWithLanePresent();
    }

    private boolean isIndexWithLanePresent() {
        NodeState oakIndexNode = this.store.getRoot().getChildNode("oak:index");
        if (!oakIndexNode.exists()) {
            log.info("lane: {} - no indexes exist under /oak:index", (Object)this.name);
            return false;
        }
        for (ChildNodeEntry childNodeEntry : oakIndexNode.getChildNodeEntries()) {
            PropertyState async = childNodeEntry.getNodeState().getProperty("async");
            if (async == null) continue;
            for (String s : (Iterable)async.getValue(Type.STRINGS)) {
                if (!s.equals(this.name)) continue;
                return true;
            }
        }
        log.info("lane: {} not present for indexes under /oak:index", (Object)this.name);
        return false;
    }

    private void markFailingIndexesAsCorrupt(NodeBuilder builder) {
        for (Map.Entry<String, TrackingCorruptIndexHandler.CorruptIndexInfo> index : this.corruptIndexHandler.getCorruptIndexData(this.name).entrySet()) {
            NodeBuilder indexBuilder = AsyncIndexUpdate.childBuilder(builder, index.getKey());
            TrackingCorruptIndexHandler.CorruptIndexInfo info = index.getValue();
            if (!indexBuilder.hasProperty("corrupt")) {
                String corruptSince = ISO8601.format((Calendar)info.getCorruptSinceAsCal());
                indexBuilder.setProperty(PropertyStates.createProperty((String)"corrupt", (Object)corruptSince, (Type)Type.DATE));
                log.info("Marking [{}] as corrupt. The index is failing {}", (Object)info.getPath(), (Object)info.getStats());
                continue;
            }
            log.debug("Failing index at [{}] is already marked as corrupt. The index is failing {}", (Object)info.getPath(), (Object)info.getStats());
        }
    }

    private static NodeBuilder childBuilder(NodeBuilder nb, String path) {
        for (String name : PathUtils.elements((String)Objects.requireNonNull(path))) {
            nb = nb.child(name);
        }
        return nb;
    }

    private void maybeCleanUpCheckpoints() {
        if (this.cleanupIntervalMinutes < 0) {
            log.debug("checkpoint cleanup skipped because cleanupIntervalMinutes set to: " + this.cleanupIntervalMinutes);
        } else if (this.indexStats.isFailing()) {
            log.debug("checkpoint cleanup skipped because index stats are failing: " + this.indexStats);
        } else {
            long currentMinutes = TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis());
            long scheduledInMinutes = this.lastCheckpointCleanUpTime + (long)this.cleanupIntervalMinutes - currentMinutes;
            if (scheduledInMinutes > 0L) {
                log.debug("checkpoint cleanup scheduled in " + scheduledInMinutes + " minutes");
            } else {
                try {
                    this.cleanUpCheckpoints();
                }
                catch (Throwable e) {
                    log.warn("Checkpoint clean up failed", e);
                }
                this.lastCheckpointCleanUpTime = currentMinutes;
            }
        }
    }

    void cleanUpCheckpoints() {
        log.debug("[{}] Cleaning up orphaned checkpoints", (Object)this.name);
        HashSet<String> keep = new HashSet<String>();
        String cp = this.indexStats.getReferenceCheckpoint();
        if (cp == null) {
            log.warn("[{}] No reference checkpoint set in index stats", (Object)this.name);
            return;
        }
        keep.add(cp);
        keep.addAll(this.indexStats.tempCps);
        log.debug("Getting checkpoint info for {}", (Object)cp);
        Map info = this.store.checkpointInfo(cp);
        String value = (String)info.get("created");
        if (value != null) {
            long current = ISO8601.parse((String)value).getTimeInMillis();
            for (String checkpoint : this.store.checkpoints()) {
                info = this.store.checkpointInfo(checkpoint);
                String creator = (String)info.get("creator");
                String created = (String)info.get("created");
                String name = (String)info.get("name");
                if (keep.contains(checkpoint) || !this.name.equals(name) || !AsyncIndexUpdate.class.getSimpleName().equals(creator) || created != null && ISO8601.parse((String)created).getTimeInMillis() + this.leaseTimeOut >= current || !this.store.release(checkpoint)) continue;
                log.info("[{}] Removed orphaned checkpoint '{}' {}", new Object[]{name, checkpoint, info});
            }
        } else {
            log.info("Checkpoint Info : '{}' for the checkpoint - {} ; keep -- {}", new Object[]{info, cp, keep});
        }
    }

    protected AsyncUpdateCallback newAsyncUpdateCallback(NodeStore store, String name, long leaseTimeOut, String beforeCheckpoint, AsyncIndexStats indexStats, AtomicBoolean stopFlag) {
        AsyncUpdateCallback callback = new AsyncUpdateCallback(store, name, leaseTimeOut, beforeCheckpoint, indexStats, stopFlag);
        callback.setValidatorProviders(this.validatorProviders);
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateIndex(NodeState before, String beforeCheckpoint, NodeState after, String afterCheckpoint, String afterTime, AsyncUpdateCallback callback, AtomicReference<String> checkpointToReleaseRef) throws CommitFailedException {
        Stopwatch watch = Stopwatch.createStarted();
        boolean updatePostRunStatus = true;
        boolean progressLogged = false;
        callback.prepare(afterCheckpoint);
        this.taskSplitter.maybeSplit(beforeCheckpoint, callback.lease);
        IndexUpdate indexUpdate = null;
        boolean indexingFailed = true;
        try {
            NodeBuilder builder = this.store.getRoot().builder();
            this.markFailingIndexesAsCorrupt(builder);
            CommitInfo info = new CommitInfo("oak:unknown", "oak:unknown", Map.of("indexingCheckpointTime", afterTime));
            indexUpdate = new IndexUpdate(this.provider, this.name, after, builder, callback, callback, info, this.corruptIndexHandler).withMissingProviderStrategy(this.missingStrategy);
            this.configureRateEstimator(indexUpdate);
            CommitFailedException exception = EditorDiff.process((Editor)VisibleEditor.wrap((Editor)indexUpdate), (NodeState)before, (NodeState)after);
            if (exception != null) {
                throw exception;
            }
            builder.child(ASYNC).setProperty(this.name, (Object)afterCheckpoint);
            builder.child(ASYNC).setProperty(PropertyStates.createProperty((String)this.lastIndexedTo, (Object)afterTime, (Type)Type.DATE));
            if (callback.isDirty() || before == EmptyNodeState.MISSING_NODE) {
                if (this.switchOnSync) {
                    this.reindexedDefinitions.addAll(indexUpdate.getReindexedDefinitions());
                    updatePostRunStatus = false;
                } else {
                    updatePostRunStatus = true;
                }
            } else {
                if (this.switchOnSync) {
                    log.debug("[{}] No changes detected after diff; will try to switch to synchronous updates on {}", (Object)this.name, this.reindexedDefinitions);
                    for (String path : this.reindexedDefinitions) {
                        NodeBuilder c = builder;
                        for (String p : PathUtils.elements((String)path)) {
                            c = c.getChildNode(p);
                        }
                        if (!c.exists() || c.getBoolean("reindex")) continue;
                        c.removeProperty("async");
                    }
                    this.reindexedDefinitions.clear();
                    if (this.store.release(afterCheckpoint)) {
                        builder.child(ASYNC).removeProperty(this.name);
                        builder.child(ASYNC).removeProperty(this.lastIndexedTo);
                    } else {
                        log.debug("[{}] Unable to release checkpoint {}", (Object)this.name, (Object)afterCheckpoint);
                    }
                }
                updatePostRunStatus = true;
            }
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, beforeCheckpoint, callback.lease, this.name);
            checkpointToReleaseRef.set(beforeCheckpoint);
            indexingFailed = false;
            if (indexUpdate.isReindexingPerformed()) {
                log.info("[{}] Reindexing completed for indexes: {} in {} ({} ms)", new Object[]{this.name, indexUpdate.getReindexStats(), watch, watch.elapsed(TimeUnit.MILLISECONDS)});
                progressLogged = true;
            }
            this.corruptIndexHandler.markWorkingIndexes(indexUpdate.getUpdatedIndexPaths());
        }
        finally {
            if (indexUpdate != null) {
                if (!indexingFailed) {
                    indexUpdate.commitProgress(IndexCommitCallback.IndexProgress.COMMIT_SUCCEDED);
                } else {
                    indexUpdate.commitProgress(IndexCommitCallback.IndexProgress.COMMIT_FAILED);
                }
            }
            callback.close();
        }
        if (!progressLogged) {
            String msg = "[{}] AsyncIndex update run completed in {}. Indexed {} nodes, {}";
            if (watch.elapsed(TimeUnit.MINUTES) >= 5L) {
                log.info(msg, new Object[]{this.name, watch, this.indexStats.getUpdates(), indexUpdate.getIndexingStats()});
            } else {
                log.debug(msg, new Object[]{this.name, watch, this.indexStats.getUpdates(), indexUpdate.getIndexingStats()});
            }
        }
        return updatePostRunStatus;
    }

    private void configureRateEstimator(IndexUpdate indexUpdate) {
        if (this.statisticsProvider.getClass().getSimpleName().equals("MetricStatisticsProvider")) {
            MetricRegistry registry = ((MetricStatisticsProvider)this.statisticsProvider).getRegistry();
            indexUpdate.setTraversalRateEstimator(new MetricRateEstimator(this.name, registry));
        }
        NodeCounterMBeanEstimator estimator = new NodeCounterMBeanEstimator(this.store);
        indexUpdate.setNodeCountEstimator(estimator);
    }

    public static String leasify(String name) {
        return name + "-lease";
    }

    static String lastIndexedTo(String name) {
        return name + "-LastIndexedTo";
    }

    private static String getTempCpName(String name) {
        return name + "-temp";
    }

    private static boolean isLeaseCheckEnabled(long leaseTimeOut) {
        return leaseTimeOut > 0L;
    }

    private static void mergeWithConcurrencyCheck(NodeStore store, List<ValidatorProvider> validatorProviders, NodeBuilder builder, final String checkpoint, final Long lease, final String name) throws CommitFailedException {
        CommitHook concurrentUpdateCheck = new CommitHook(){

            @NotNull
            public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
                NodeState async = before.getChildNode(AsyncIndexUpdate.ASYNC);
                if (!(checkpoint != null && !Objects.equals(checkpoint, async.getString(name)) || lease != null && lease.longValue() != async.getLong(AsyncIndexUpdate.leasify(name)))) {
                    return after;
                }
                throw AsyncIndexUpdate.newConcurrentUpdateException();
            }
        };
        ArrayList<ValidatorProvider> editorProviders = new ArrayList<ValidatorProvider>();
        editorProviders.add(new ConflictValidatorProvider());
        editorProviders.addAll(validatorProviders);
        CompositeHook hooks = new CompositeHook(new CommitHook[]{ResetCommitAttributeHook.INSTANCE, ConflictHook.of(new AnnotatingConflictHandler()), new EditorHook(CompositeEditorProvider.compose(editorProviders)), concurrentUpdateCheck});
        try {
            store.merge(builder, (CommitHook)hooks, AsyncIndexUpdate.createCommitInfo());
        }
        catch (CommitFailedException ex) {
            if (ex.isOfType("State") && ex.getCode() == 1) {
                throw AsyncIndexUpdate.newConcurrentUpdateException();
            }
            throw ex;
        }
    }

    private static CommitInfo createCommitInfo() {
        Map<String, SimpleCommitContext> info = Map.of("oak.commitAttributes", new SimpleCommitContext());
        return new CommitInfo("oak:unknown", "oak:unknown", info);
    }

    protected AsyncIndexUpdate setLeaseTimeOut(long leaseTimeOut) {
        this.leaseTimeOut = leaseTimeOut;
        return this;
    }

    protected long getLeaseTimeOut() {
        return this.leaseTimeOut;
    }

    protected AsyncIndexUpdate setCloseTimeOut(int timeOutInSec) {
        this.softTimeOutSecs = timeOutInSec;
        return this;
    }

    public void setValidatorProviders(List<ValidatorProvider> validatorProviders) {
        this.validatorProviders = Objects.requireNonNull(validatorProviders);
    }

    public void setCorruptIndexHandler(TrackingCorruptIndexHandler corruptIndexHandler) {
        this.corruptIndexHandler = Objects.requireNonNull(corruptIndexHandler);
    }

    TrackingCorruptIndexHandler getCorruptIndexHandler() {
        return this.corruptIndexHandler;
    }

    public boolean isClosed() {
        return this.closed || this.forcedStopFlag.get();
    }

    boolean isClosing() {
        return this.runPermit.hasQueuedThreads();
    }

    private static void preAsyncRunStatsStats(AsyncIndexStats stats) {
        stats.start(AsyncIndexUpdate.now());
    }

    private static void postAsyncRunStatsStatus(AsyncIndexStats stats) {
        stats.done(AsyncIndexUpdate.now());
    }

    private static String now() {
        return ISO8601.format((Calendar)Calendar.getInstance());
    }

    public AsyncIndexStats getIndexStats() {
        return this.indexStats;
    }

    public boolean isFinished() {
        return this.indexStats.getStatus() == "done";
    }

    private static boolean noVisibleChanges(NodeState before, NodeState after) {
        return after.compareAgainstBaseState(before, new NodeStateDiff(){

            public boolean propertyAdded(PropertyState after) {
                return AsyncIndexUpdate.isHidden(after.getName());
            }

            public boolean propertyChanged(PropertyState before, PropertyState after) {
                return AsyncIndexUpdate.isHidden(after.getName());
            }

            public boolean propertyDeleted(PropertyState before) {
                return AsyncIndexUpdate.isHidden(before.getName());
            }

            public boolean childNodeAdded(String name, NodeState after) {
                return AsyncIndexUpdate.isHidden(name);
            }

            public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                return AsyncIndexUpdate.isHidden(name) || after.compareAgainstBaseState(before, (NodeStateDiff)this);
            }

            public boolean childNodeDeleted(String name, NodeState before) {
                return AsyncIndexUpdate.isHidden(name);
            }
        });
    }

    private static boolean isHidden(String name) {
        return name.charAt(0) == ':';
    }

    public boolean isFailing() {
        return this.indexStats.isFailing();
    }

    private static Iterable<String> getStrings(NodeBuilder b, String p) {
        PropertyState ps = b.getProperty(p);
        if (ps != null) {
            return (Iterable)ps.getValue(Type.STRINGS);
        }
        return new HashSet<String>();
    }

    IndexTaskSpliter getTaskSplitter() {
        return this.taskSplitter;
    }

    public void setIndexMBeanRegistration(IndexMBeanRegistration mbeanRegistration) {
        this.mbeanRegistration = mbeanRegistration;
    }

    public String getName() {
        return this.name;
    }

    private static CommitFailedException newConcurrentUpdateException() {
        return new CommitFailedException("Async", 1, "Concurrent update detected");
    }

    class IndexTaskSpliter {
        private Set<String> paths = null;
        private String newIndexTaskName = null;
        private String lastReferencedCp;
        private Set<String> registeredTasks = new HashSet<String>();

        IndexTaskSpliter() {
        }

        void registerSplit(Set<String> paths, String newIndexTaskName) {
            log.info("[{}] Registered split of following index definitions {} to new async task {}.", new Object[]{AsyncIndexUpdate.this.name, paths, newIndexTaskName});
            this.paths = new HashSet<String>(paths);
            this.newIndexTaskName = newIndexTaskName;
        }

        void maybeSplit(@Nullable String refCheckpoint, Long lease) throws CommitFailedException {
            if (this.paths == null) {
                return;
            }
            this.split(refCheckpoint, lease);
        }

        private void split(@Nullable String refCheckpoint, Long lease) throws CommitFailedException {
            NodeBuilder builder = AsyncIndexUpdate.this.store.getRoot().builder();
            if (refCheckpoint != null) {
                String tempCpName = AsyncIndexUpdate.getTempCpName(AsyncIndexUpdate.this.name);
                NodeBuilder async = builder.child(AsyncIndexUpdate.ASYNC);
                async.setProperty(this.newIndexTaskName, (Object)refCheckpoint);
                HashSet<String> temps = new HashSet<String>();
                for (String cp : AsyncIndexUpdate.getStrings(async, tempCpName)) {
                    if (cp.equals(refCheckpoint)) continue;
                    temps.add(cp);
                }
                async.setProperty(tempCpName, temps, Type.STRINGS);
                AsyncIndexUpdate.this.indexStats.setTempCheckpoints(temps);
            }
            HashSet<String> updated = new HashSet<String>();
            for (String path : this.paths) {
                NodeBuilder c = builder;
                for (String p : PathUtils.elements((String)path)) {
                    c = c.getChildNode(p);
                }
                if (!c.exists() || !AsyncIndexUpdate.this.name.equals(c.getString("async"))) continue;
                c.setProperty("async", (Object)this.newIndexTaskName);
                updated.add(path);
            }
            if (!updated.isEmpty()) {
                AsyncIndexUpdate.mergeWithConcurrencyCheck(AsyncIndexUpdate.this.store, AsyncIndexUpdate.this.validatorProviders, builder, refCheckpoint, lease, AsyncIndexUpdate.this.name);
                log.info("[{}] Successfully split index definitions {} to async task named {} with referenced checkpoint {}.", new Object[]{AsyncIndexUpdate.this.name, updated, this.newIndexTaskName, refCheckpoint});
                this.lastReferencedCp = refCheckpoint;
            }
            this.paths = null;
            this.newIndexTaskName = null;
        }

        public String getLastReferencedCp() {
            return this.lastReferencedCp;
        }

        void registerAsyncIndexer(String newTask, long delayInSeconds) {
            if (this.registeredTasks.contains(newTask)) {
                log.warn("[{}] Task {} is already registered.", (Object)AsyncIndexUpdate.this.name, (Object)newTask);
                return;
            }
            if (AsyncIndexUpdate.this.mbeanRegistration != null) {
                log.info("[{}] Registering a new indexing task {} running each {} seconds.", new Object[]{AsyncIndexUpdate.this.name, newTask, delayInSeconds});
                AsyncIndexUpdate task = new AsyncIndexUpdate(newTask, AsyncIndexUpdate.this.store, AsyncIndexUpdate.this.provider);
                AsyncIndexUpdate.this.mbeanRegistration.registerAsyncIndexer(task, delayInSeconds);
                this.registeredTasks.add(newTask);
            }
        }
    }

    static class DefaultMissingIndexProviderStrategy
    extends IndexUpdate.MissingIndexProviderStrategy {
        DefaultMissingIndexProviderStrategy() {
        }

        @Override
        public void onMissingIndex(String type, NodeBuilder definition, String path) throws CommitFailedException {
            if (this.isDisabled(type)) {
                return;
            }
            throw new CommitFailedException("Async", 2, "Missing index provider detected for type [" + type + "] on index [" + path + "]");
        }
    }

    final class AsyncIndexStats
    extends AnnotatedStandardMBean
    implements IndexStatsMBean {
        private String start;
        private String done;
        private String status;
        private String referenceCp;
        private String processedCp;
        private Set<String> tempCps;
        private volatile boolean isPaused;
        private volatile boolean forcedLeaseRelease;
        private volatile long updates;
        private volatile long nodesRead;
        private final Stopwatch watch;
        private final ExecutionStats execStats;
        private volatile boolean failing;
        private long latestErrorWarn;
        private String failingSince;
        private String latestError;
        private String latestErrorTime;
        private long consecutiveFailures;

        protected AsyncIndexStats(String name, StatisticsProvider statsProvider) {
            super(IndexStatsMBean.class);
            this.start = "";
            this.done = "";
            this.status = "init";
            this.referenceCp = "";
            this.processedCp = "";
            this.tempCps = new HashSet<String>();
            this.watch = Stopwatch.createUnstarted();
            this.failing = false;
            this.latestErrorWarn = 0L;
            this.failingSince = "";
            this.latestError = null;
            this.latestErrorTime = "";
            this.consecutiveFailures = 0L;
            this.execStats = new ExecutionStats(name, statsProvider);
        }

        public void start(String now) {
            this.status = "running";
            this.start = now;
            this.done = "";
            if (this.watch.isRunning()) {
                this.watch.reset();
            }
            this.watch.start();
        }

        public void done(String now) {
            this.status = AsyncIndexUpdate.this.corruptIndexHandler.isFailing(AsyncIndexUpdate.this.name) ? "failing" : "done";
            this.done = now;
            if (this.watch.isRunning()) {
                this.watch.stop();
            }
            this.execStats.doneOneCycle(this.watch.elapsed(TimeUnit.MILLISECONDS), this.updates);
            this.watch.reset();
        }

        public void failed(Exception e) {
            boolean isConcurrentUpdateException;
            boolean bl = isConcurrentUpdateException = e.getMessage() != null && e.getMessage().startsWith(AsyncIndexUpdate.CONCURRENT_EXCEPTION_MSG);
            if (e == INTERRUPTED) {
                this.status = "interrupted";
                log.info("[{}] The index update interrupted", (Object)AsyncIndexUpdate.this.name);
                log.debug("[{}] The index update interrupted", (Object)AsyncIndexUpdate.this.name, (Object)e);
                return;
            }
            this.latestError = ExceptionUtils.getStackTrace((Throwable)e);
            this.latestErrorTime = AsyncIndexUpdate.now();
            ++this.consecutiveFailures;
            if (!this.failing) {
                this.failing = true;
                this.failingSince = this.latestErrorTime;
                this.latestErrorWarn = System.currentTimeMillis();
                if (isConcurrentUpdateException) {
                    log.info("[{}] The index update failed : {}", (Object)AsyncIndexUpdate.this.name, (Object)e.getMessage());
                } else {
                    log.warn("[{}] The index update failed", (Object)AsyncIndexUpdate.this.name, (Object)e);
                }
            } else {
                boolean warn;
                boolean bl2 = warn = System.currentTimeMillis() - this.latestErrorWarn > ERROR_WARN_INTERVAL;
                if (warn) {
                    this.latestErrorWarn = System.currentTimeMillis();
                    if (isConcurrentUpdateException) {
                        log.info("[{}] The index update is still failing : {}", (Object)AsyncIndexUpdate.this.name, (Object)e.getMessage());
                    } else {
                        log.warn("[{}] The index update is still failing", (Object)AsyncIndexUpdate.this.name, (Object)e);
                    }
                } else {
                    log.debug("[{}] The index update is still failing", (Object)AsyncIndexUpdate.this.name, (Object)e);
                }
            }
        }

        public void fixed() {
            if (AsyncIndexUpdate.this.corruptIndexHandler.isFailing(AsyncIndexUpdate.this.name)) {
                log.info("[{}] Index update no longer fails but some corrupt indexes have been skipped {}", (Object)AsyncIndexUpdate.this.name, AsyncIndexUpdate.this.corruptIndexHandler.getCorruptIndexData(AsyncIndexUpdate.this.name).keySet());
            } else {
                log.info("[{}] Index update no longer fails", (Object)AsyncIndexUpdate.this.name);
            }
            this.failing = false;
            this.failingSince = "";
            this.consecutiveFailures = 0L;
            this.latestErrorWarn = 0L;
            this.latestError = null;
            this.latestErrorTime = "";
        }

        public boolean isFailing() {
            return this.failing || AsyncIndexUpdate.this.corruptIndexHandler.isFailing(AsyncIndexUpdate.this.name);
        }

        public boolean didLastIndexingCycleFailed() {
            return this.failing;
        }

        public String getName() {
            return AsyncIndexUpdate.this.name;
        }

        public String getStart() {
            return this.start;
        }

        public String getDone() {
            return this.done;
        }

        public String getStatus() {
            return this.status;
        }

        public String getLastIndexedTime() {
            PropertyState ps = AsyncIndexUpdate.this.store.getRoot().getChildNode(AsyncIndexUpdate.ASYNC).getProperty(AsyncIndexUpdate.this.lastIndexedTo);
            return ps != null ? (String)ps.getValue(Type.STRING) : null;
        }

        public void pause() {
            log.debug("[{}] Pausing the async indexer", (Object)AsyncIndexUpdate.this.name);
            this.isPaused = true;
        }

        public String abortAndPause() {
            this.pause();
            AsyncIndexUpdate.this.forcedStopFlag.set(true);
            String msg = "";
            if (AsyncIndexUpdate.this.runPermit.availablePermits() == 0) {
                msg = "Abort request placed for current run. ";
            }
            return msg + "Indexing is paused now. Invoke 'resume' to resume indexing";
        }

        public String releaseLeaseForPausedLane() {
            if (this.isPaused()) {
                this.forcedLeaseRelease = true;
                return "LeaseRelease flag set";
            }
            return "Please pause the lane to release lease";
        }

        public void resume() {
            log.debug("[{}] Resuming the async indexer", (Object)AsyncIndexUpdate.this.name);
            this.isPaused = false;
            AsyncIndexUpdate.this.forcedStopFlag.set(false);
            this.forcedLeaseRelease = false;
        }

        public boolean isPaused() {
            return this.isPaused;
        }

        void reset() {
            this.updates = 0L;
            this.nodesRead = 0L;
        }

        long incUpdates() {
            return ++this.updates;
        }

        long incTraversal() {
            return ++this.nodesRead;
        }

        public long getUpdates() {
            return this.updates;
        }

        public long getNodesReadCount() {
            return this.nodesRead;
        }

        void setReferenceCheckpoint(String checkpoint) {
            this.referenceCp = checkpoint;
        }

        public String getReferenceCheckpoint() {
            return this.referenceCp;
        }

        public String forceIndexLaneCatchup(String confirmMessage) throws CommitFailedException {
            if (!"CONFIRM".equals(confirmMessage)) {
                String msg = "Please confirm that you want to force the lane catch-up by passing 'CONFIRM' as argument";
                log.warn(msg);
                return msg;
            }
            if (!this.isFailing()) {
                String msg = "The lane is not failing. This operation should only be performed if the lane is failing, it should first be allowed to catch up on its own.";
                log.warn(msg);
                return msg;
            }
            try {
                log.info("Running a forced catch-up for indexing lane [{}]. ", (Object)AsyncIndexUpdate.this.name);
                this.abortAndPause();
                log.info("Aborted and paused async indexing for lane [{}]", (Object)AsyncIndexUpdate.this.name);
                this.releaseLeaseForPausedLane();
                log.info("Released lease for paused lane [{}]", (Object)AsyncIndexUpdate.this.name);
                String newReferenceCheckpoint = AsyncIndexUpdate.this.store.checkpoint(AsyncIndexUpdate.this.lifetime, Map.of("creator", AsyncIndexUpdate.class.getSimpleName(), "created", AsyncIndexUpdate.now(), "thread", Thread.currentThread().getName(), "name", AsyncIndexUpdate.this.name + "-forceModified"));
                String existingReferenceCheckpoint = this.referenceCp;
                log.info("Modifying the referred checkpoint for lane [{}] from {} to {}. This means that any content modifications between these checkpoints will not reflect in the indexes on this lane. Reindexing is needed to get this content indexed.", new Object[]{AsyncIndexUpdate.this.name, existingReferenceCheckpoint, newReferenceCheckpoint});
                NodeBuilder builder = AsyncIndexUpdate.this.store.getRoot().builder();
                builder.child(AsyncIndexUpdate.ASYNC).setProperty(AsyncIndexUpdate.this.name, (Object)newReferenceCheckpoint);
                this.referenceCp = newReferenceCheckpoint;
                AsyncIndexUpdate.mergeWithConcurrencyCheck(AsyncIndexUpdate.this.store, AsyncIndexUpdate.this.validatorProviders, builder, existingReferenceCheckpoint, null, AsyncIndexUpdate.this.name);
                if (AsyncIndexUpdate.this.store.release(existingReferenceCheckpoint)) {
                    log.info("Old reference checkpoint {} removed or didn't exist", (Object)existingReferenceCheckpoint);
                } else {
                    log.warn("Unable to remove old reference checkpoint {}. This can result in orphaned checkpoints and would need to be removed manually.", (Object)existingReferenceCheckpoint);
                }
                this.resume();
                log.info("Resumed async indexing for lane [{}]", (Object)AsyncIndexUpdate.this.name);
                return "Lane successfully forced to catch-up. New reference checkpoint is " + newReferenceCheckpoint + " . Please make sure to perform reindexing to get the diff content indexed.";
            }
            catch (Exception e) {
                log.error("Exception while trying to force update the indexing lane [{}]", (Object)AsyncIndexUpdate.this.name, (Object)e);
                if (this.isPaused()) {
                    this.resume();
                    log.info("Resuming the lane [{}] as it was paused during the operation", (Object)AsyncIndexUpdate.this.name);
                }
                return "Unable to complete the force update due to " + e.getMessage() + ".Please check logs for more details";
            }
        }

        void setProcessedCheckpoint(String checkpoint) {
            this.processedCp = checkpoint;
        }

        public String getProcessedCheckpoint() {
            return this.processedCp;
        }

        void setTempCheckpoints(Set<String> tempCheckpoints) {
            this.tempCps = tempCheckpoints;
        }

        void releaseTempCheckpoint(String tempCheckpoint) {
            this.tempCps.remove(tempCheckpoint);
        }

        public String getTemporaryCheckpoints() {
            return this.tempCps.toString();
        }

        public long getTotalExecutionCount() {
            return this.execStats.getExecutionCounter().getCount();
        }

        public CompositeData getExecutionCount() {
            return this.execStats.getExecutionCount();
        }

        public CompositeData getExecutionTime() {
            return null;
        }

        public CompositeData getIndexedNodesCount() {
            return this.execStats.getIndexedNodesCount();
        }

        public CompositeData getConsolidatedExecutionStats() {
            return this.execStats.getConsolidatedStats();
        }

        public void resetConsolidatedExecutionStats() {
        }

        public String toString() {
            return "AsyncIndexStats [start=" + this.start + ", done=" + this.done + ", status=" + this.status + ", paused=" + this.isPaused + ", failing=" + this.failing + ", failingSince=" + this.failingSince + ", consecutiveFailures=" + this.consecutiveFailures + ", updates=" + this.updates + ", referenceCheckpoint=" + this.referenceCp + ", processedCheckpoint=" + this.processedCp + " ,tempCheckpoints=" + this.tempCps + ", latestErrorTime=" + this.latestErrorTime + ", latestError=" + this.latestError + " ]";
        }

        ExecutionStats getExecutionStats() {
            return this.execStats;
        }

        public void splitIndexingTask(String paths, String newIndexTaskName) {
            this.splitIndexingTask(SetUtils.toSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)paths)), newIndexTaskName);
        }

        private void splitIndexingTask(Set<String> paths, String newIndexTaskName) {
            AsyncIndexUpdate.this.taskSplitter.registerSplit(paths, newIndexTaskName);
        }

        public void registerAsyncIndexer(String name, long delayInSeconds) {
            AsyncIndexUpdate.this.taskSplitter.registerAsyncIndexer(name, delayInSeconds);
        }

        public String getFailingSince() {
            return this.failingSince;
        }

        public long getConsecutiveFailedExecutions() {
            return this.consecutiveFailures;
        }

        public String getLatestError() {
            return this.latestError;
        }

        public String getLatestErrorTime() {
            return this.latestErrorTime;
        }

        public TabularData getFailingIndexStats() {
            return AsyncIndexUpdate.this.corruptIndexHandler.getFailingIndexStats(AsyncIndexUpdate.this.name);
        }

        class ExecutionStats {
            public static final String INDEXER_COUNT = "INDEXER_COUNT";
            public static final String INDEXER_NODE_COUNT = "INDEXER_NODE_COUNT";
            private final MeterStats indexerExecutionCountMeter;
            private final MeterStats indexedNodeCountMeter;
            private final TimerStats indexerTimer;
            private final HistogramStats indexedNodePerCycleHisto;
            private final CounterStats lastIndexedTime;
            private StatisticsProvider statisticsProvider;
            private final String[] names = new String[]{"Executions", "Nodes"};
            private final String name;
            private CompositeType consolidatedType;

            public ExecutionStats(String name, StatisticsProvider statsProvider) {
                this.name = name;
                this.statisticsProvider = statsProvider;
                this.indexerExecutionCountMeter = statsProvider.getMeter(this.stats(INDEXER_COUNT), StatsOptions.DEFAULT);
                this.indexedNodeCountMeter = statsProvider.getMeter(this.stats(INDEXER_NODE_COUNT), StatsOptions.DEFAULT);
                this.indexerTimer = statsProvider.getTimer(this.stats("INDEXER_TIME"), StatsOptions.METRICS_ONLY);
                this.indexedNodePerCycleHisto = statsProvider.getHistogram(this.stats("INDEXER_NODE_COUNT_HISTO"), StatsOptions.METRICS_ONLY);
                this.lastIndexedTime = statsProvider.getCounterStats(this.stats("LAST_INDEXED_TIME"), StatsOptions.DEFAULT);
                try {
                    this.consolidatedType = new CompositeType("ConsolidatedStats", "Consolidated stats", this.names, this.names, new OpenType[]{SimpleType.LONG, SimpleType.LONG});
                }
                catch (OpenDataException e) {
                    log.warn("[{}] Error in creating CompositeType for consolidated stats", (Object)AsyncIndexUpdate.this.name, (Object)e);
                }
            }

            public void doneOneCycle(long timeInMillis, long updates) {
                this.indexerExecutionCountMeter.mark();
                this.indexedNodeCountMeter.mark(updates);
                this.indexerTimer.update(timeInMillis, TimeUnit.MILLISECONDS);
                this.indexedNodePerCycleHisto.update(updates);
                long previousLastIndexedTime = this.lastIndexedTime.getCount();
                this.lastIndexedTime.inc(System.currentTimeMillis() - previousLastIndexedTime);
            }

            public Counting getExecutionCounter() {
                return this.indexerExecutionCountMeter;
            }

            public Counting getIndexedNodeCount() {
                return this.indexedNodeCountMeter;
            }

            private CompositeData getExecutionCount() {
                return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(this.stats(INDEXER_COUNT)), (String)"Indexer Execution Count");
            }

            private CompositeData getIndexedNodesCount() {
                return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(this.stats(INDEXER_NODE_COUNT)), (String)"Indexer Node Count");
            }

            private CompositeData getConsolidatedStats() {
                try {
                    Object[] values = new Long[]{this.indexerExecutionCountMeter.getCount(), this.indexedNodeCountMeter.getCount()};
                    return new CompositeDataSupport(this.consolidatedType, this.names, values);
                }
                catch (Exception e) {
                    log.error("[{}] Error retrieving consolidated stats", (Object)this.name, (Object)e);
                    return null;
                }
            }

            private String stats(String suffix) {
                return this.name + "." + suffix;
            }

            private TimeSeries getTimeSeries(String name) {
                return this.statisticsProvider.getStats().getTimeSeries(name, true);
            }
        }
    }

    protected static class AsyncUpdateCallback
    implements IndexUpdateCallback,
    NodeTraversalCallback {
        public static final int LEASE_CHECK_INTERVAL = 10;
        private final NodeStore store;
        private String checkpoint;
        private final String tempCpName;
        private final long leaseTimeOut;
        private final String name;
        private final String leaseName;
        private final AsyncIndexStats indexStats;
        private final AtomicBoolean forcedStop;
        private List<ValidatorProvider> validatorProviders = Collections.emptyList();
        private Long lease = null;
        private boolean hasLease = false;

        public AsyncUpdateCallback(NodeStore store, String name, long leaseTimeOut, String checkpoint, AsyncIndexStats indexStats, AtomicBoolean forcedStop) {
            this.store = store;
            this.name = name;
            this.forcedStop = forcedStop;
            this.leaseTimeOut = leaseTimeOut;
            this.checkpoint = checkpoint;
            this.tempCpName = AsyncIndexUpdate.getTempCpName(name);
            this.indexStats = indexStats;
            this.leaseName = AsyncIndexUpdate.leasify(name);
        }

        protected void initLease() throws CommitFailedException {
            if (this.hasLease) {
                return;
            }
            NodeState root = this.store.getRoot();
            NodeState async = root.getChildNode(AsyncIndexUpdate.ASYNC);
            if (AsyncIndexUpdate.isLeaseCheckEnabled(this.leaseTimeOut)) {
                long now = this.getTime();
                this.lease = now + 2L * this.leaseTimeOut;
                long beforeLease = async.getLong(this.leaseName);
                if (beforeLease > now) {
                    throw AsyncIndexUpdate.newConcurrentUpdateException();
                }
                NodeBuilder builder = root.builder();
                builder.child(AsyncIndexUpdate.ASYNC).setProperty(this.leaseName, (Object)this.lease);
                AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, this.checkpoint, beforeLease, this.name);
            } else {
                this.lease = null;
                if (async.hasProperty(this.leaseName)) {
                    NodeBuilder builder = root.builder();
                    builder.child(AsyncIndexUpdate.ASYNC).removeProperty(this.leaseName);
                    AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, this.checkpoint, null, this.name);
                }
            }
            this.hasLease = true;
        }

        protected void prepare(String afterCheckpoint) throws CommitFailedException {
            if (!this.hasLease) {
                this.initLease();
            }
            NodeState root = this.store.getRoot();
            NodeBuilder builder = root.builder();
            NodeBuilder async = builder.child(AsyncIndexUpdate.ASYNC);
            this.updateTempCheckpoints(async, this.checkpoint, afterCheckpoint);
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, this.checkpoint, this.lease, this.name);
            this.indexStats.reset();
        }

        private void updateTempCheckpoints(NodeBuilder async, String checkpoint, String afterCheckpoint) {
            this.indexStats.setReferenceCheckpoint(checkpoint);
            this.indexStats.setProcessedCheckpoint(afterCheckpoint);
            HashSet<String> temps = new HashSet<String>();
            for (String cp : AsyncIndexUpdate.getStrings(async, this.tempCpName)) {
                if (cp.equals(checkpoint)) {
                    temps.add(cp);
                    continue;
                }
                boolean released = this.store.release(cp);
                log.debug("[{}] Releasing temporary checkpoint {}: {}", new Object[]{this.name, cp, released});
                if (released) continue;
                temps.add(cp);
            }
            temps.add(afterCheckpoint);
            async.setProperty(this.tempCpName, temps, Type.STRINGS);
            this.indexStats.setTempCheckpoints(temps);
        }

        boolean isDirty() {
            return this.indexStats.getUpdates() > 0L;
        }

        void close() throws CommitFailedException {
            if (AsyncIndexUpdate.isLeaseCheckEnabled(this.leaseTimeOut)) {
                NodeBuilder builder = this.store.getRoot().builder();
                NodeBuilder async = builder.child(AsyncIndexUpdate.ASYNC);
                async.removeProperty(this.leaseName);
                AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, async.getString(this.name), this.lease, this.name);
            }
        }

        @Override
        public void indexUpdate() throws CommitFailedException {
            this.checkIfStopped();
            this.indexStats.incUpdates();
        }

        @Override
        public void traversedNode(NodeTraversalCallback.PathSource pathSource) throws CommitFailedException {
            long now;
            this.checkIfStopped();
            if (this.indexStats.incTraversal() % 10L == 0L && AsyncIndexUpdate.isLeaseCheckEnabled(this.leaseTimeOut) && (now = this.getTime()) + this.leaseTimeOut > this.lease) {
                long newLease = now + 2L * this.leaseTimeOut;
                NodeBuilder builder = this.store.getRoot().builder();
                builder.child(AsyncIndexUpdate.ASYNC).setProperty(this.leaseName, (Object)newLease);
                AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, this.validatorProviders, builder, this.checkpoint, this.lease, this.name);
                this.lease = newLease;
            }
        }

        protected long getTime() {
            return System.currentTimeMillis();
        }

        public void setCheckpoint(String checkpoint) {
            this.checkpoint = checkpoint;
        }

        public void setValidatorProviders(List<ValidatorProvider> validatorProviders) {
            this.validatorProviders = Objects.requireNonNull(validatorProviders);
        }

        private void checkIfStopped() throws CommitFailedException {
            if (this.forcedStop.get()) {
                this.forcedStop.set(false);
                throw INTERRUPTED;
            }
        }
    }
}

