/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath.impl;

import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.namepath.impl.GlobalNameMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalNameMapper
extends GlobalNameMapper {
    protected final Map<String, String> local;
    private static final Logger log = LoggerFactory.getLogger(LocalNameMapper.class);

    public LocalNameMapper(Root root, Map<String, String> local) {
        super(root);
        this.local = local;
    }

    public LocalNameMapper(Map<String, String> global, Map<String, String> local) {
        super(global);
        this.local = local;
    }

    @Override
    @NotNull
    public synchronized Map<String, String> getSessionLocalMappings() {
        return this.local;
    }

    @Override
    @NotNull
    public synchronized String getJcrName(@NotNull String oakName) {
        int colon;
        Objects.requireNonNull(oakName);
        Validate.checkArgument((!oakName.startsWith(":") ? 1 : 0) != 0, (String)oakName);
        Validate.checkArgument((!LocalNameMapper.isExpandedName(oakName) ? 1 : 0) != 0, (String)oakName);
        if (!this.local.isEmpty() && (colon = oakName.indexOf(58)) > 0) {
            String oakPrefix = oakName.substring(0, colon);
            String uri = this.getNamespacesProperty(oakPrefix);
            if (uri == null) {
                throw new IllegalStateException("No namespace mapping found for " + oakName);
            }
            for (Map.Entry<String, String> entry : this.local.entrySet()) {
                if (!uri.equals(entry.getValue())) continue;
                String jcrPrefix = entry.getKey();
                if (jcrPrefix.equals(oakPrefix)) {
                    return oakName;
                }
                return jcrPrefix + oakName.substring(colon);
            }
            if (this.local.containsKey(oakPrefix)) {
                int i = 2;
                while (true) {
                    String jcrPrefix;
                    if (!this.local.containsKey(jcrPrefix = oakPrefix + i)) {
                        log.warn("no prefix found for namespace name '" + uri + "', using unmapped temporary prefix '" + jcrPrefix + "' for now (see OAK-10544)");
                        return jcrPrefix + oakName.substring(colon);
                    }
                    ++i;
                }
            }
        }
        return oakName;
    }

    @Override
    @Nullable
    public synchronized String getOakNameOrNull(@NotNull String jcrName) {
        int colon;
        String oakName;
        Objects.requireNonNull(jcrName);
        if (jcrName.startsWith("{") && (oakName = this.getOakNameFromExpanded(jcrName)) != jcrName) {
            return oakName;
        }
        if (!this.local.isEmpty() && (colon = jcrName.indexOf(58)) > 0) {
            String jcrPrefix = jcrName.substring(0, colon);
            String uri = this.local.get(jcrPrefix);
            if (uri != null) {
                String oakPrefix = this.getOakPrefixOrNull(uri);
                if (oakPrefix == null) {
                    return null;
                }
                if (jcrPrefix.equals(oakPrefix)) {
                    return jcrName;
                }
                return oakPrefix + jcrName.substring(colon);
            }
            String mapping = this.getNamespacesProperty(jcrPrefix);
            if (mapping != null && this.local.values().contains(mapping)) {
                return null;
            }
        }
        return jcrName;
    }
}

