/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.ComThread;
import com.jacob.com.JacobObject;
import com.jacob.com.LibraryLoader;
import com.jacob.com.SafeArray;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ROT {
    protected static final boolean USE_AUTOMATIC_GARBAGE_COLLECTION = "true".equalsIgnoreCase(System.getProperty("com.jacob.autogc"));
    private static HashMap rot = new HashMap();

    static {
        LibraryLoader.loadJacobLibrary();
    }

    protected static synchronized Map addThread() {
        String t_name = Thread.currentThread().getName();
        if (!rot.containsKey(t_name)) {
            AbstractMap tab = null;
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: Automatic GC flag == " + USE_AUTOMATIC_GARBAGE_COLLECTION);
            }
            tab = !USE_AUTOMATIC_GARBAGE_COLLECTION ? new HashMap() : new WeakHashMap();
            rot.put(t_name, tab);
        }
        return ROT.getThreadObjects(false);
    }

    protected static synchronized Map getThreadObjects(boolean createIfDoesNotExist) {
        String t_name = Thread.currentThread().getName();
        if (!rot.containsKey(t_name) && createIfDoesNotExist) {
            ROT.addThread();
        }
        return (Map)rot.get(t_name);
    }

    protected static synchronized void clearObjects() {
        Map tab = ROT.getThreadObjects(false);
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ROT: " + rot.keySet().size() + " thread tables exist");
        }
        if (tab != null) {
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: " + tab.keySet().size() + " objects to clear in this thread ");
            }
            Iterator<Object> it = USE_AUTOMATIC_GARBAGE_COLLECTION ? tab.keySet().iterator() : tab.values().iterator();
            while (it.hasNext()) {
                JacobObject o = (JacobObject)it.next();
                if (o == null) continue;
                if (JacobObject.isDebugEnabled()) {
                    if (o instanceof SafeArray) {
                        JacobObject.debug("ROT: removing " + o.getClass().getName());
                    } else {
                        JacobObject.debug("ROT: removing " + o.hashCode() + "->" + o.getClass().getName());
                    }
                }
                o.safeRelease();
            }
            tab.clear();
            rot.remove(Thread.currentThread().getName());
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: thread table cleared and removed");
            }
        } else if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ROT: nothing to clear!");
        }
    }

    protected static Object getMapKey(Map targetMap, JacobObject o) {
        if (targetMap instanceof WeakHashMap) {
            return o;
        }
        return new Integer(o.hashCode());
    }

    protected static Object getMapValue(Map targetMap, JacobObject o) {
        if (targetMap instanceof WeakHashMap) {
            return null;
        }
        return o;
    }

    protected static synchronized void removeObject(JacobObject o) {
        String t_name = Thread.currentThread().getName();
        Map tab = (Map)rot.get(t_name);
        if (tab != null) {
            tab.remove(ROT.getMapKey(tab, o));
        }
        o.safeRelease();
    }

    protected static synchronized void addObject(JacobObject o) {
        Map tab = ROT.getThreadObjects(false);
        if (tab == null) {
            ComThread.InitMTA(false);
            tab = ROT.getThreadObjects(true);
        }
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ROT: adding " + o + "->" + o.getClass().getName() + " table size prior to addition:" + tab.size());
        }
        if (tab != null) {
            tab.put(ROT.getMapKey(tab, o), ROT.getMapValue(tab, o));
        }
    }
}

