/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.comment.dao.CommentDAO;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.comment.model.CommentedPublicationInfo;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.comment.service.notification.CommentEventNotifier;
import org.silverpeas.core.comment.socialnetwork.SocialInformationComment;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Named(value="commentService")
public class DefaultCommentService
implements CommentService,
ComponentInstanceDeletion {
    private static final String MESSAGES_PATH = "org.silverpeas.util.comment.multilang.comment";
    @Inject
    private CommentDAO commentDAO;
    @Inject
    private CommentEventNotifier notifier;

    protected DefaultCommentService() {
    }

    protected CommentDAO getCommentDAO() {
        return this.commentDAO;
    }

    @Override
    public Comment createComment(Comment cmt) {
        Comment comment = this.getCommentDAO().saveComment(cmt);
        this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, (Serializable[])new Comment[]{comment});
        return comment;
    }

    @Override
    public Comment createAndIndexComment(Comment cmt) {
        Comment comment = this.createComment(cmt);
        this.createIndex(comment);
        return comment;
    }

    @Override
    public void deleteComment(CommentId commentId) {
        Comment comment = this.getComment(commentId);
        this.deleteComment(comment);
    }

    @Override
    public void deleteAllCommentsOnResource(String resourceType, ResourceReference resourceRef) {
        List<Comment> comments = this.getCommentDAO().getAllCommentsByForeignKey(resourceType, resourceRef);
        for (Comment comment : comments) {
            this.deleteComment(comment);
        }
    }

    @Override
    public void deleteComment(Comment comment) {
        this.deleteIndex(comment);
        this.getCommentDAO().removeComment(comment.getIdentifier());
        this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, (Serializable[])new Comment[]{comment});
    }

    @Override
    public void moveComments(String resourceType, ResourceReference fromResource, ResourceReference toResource) {
        this.unindexAllCommentsOnPublication(resourceType, fromResource);
        this.getCommentDAO().moveComments(resourceType, fromResource, toResource);
    }

    @Override
    public void moveAndReindexComments(String resourceType, ResourceReference fromResource, ResourceReference toResource) {
        this.moveComments(resourceType, fromResource, toResource);
        this.indexAllCommentsOnPublication(resourceType, toResource);
    }

    @Override
    public void updateComment(Comment cmt) {
        this.getCommentDAO().updateComment(cmt);
    }

    @Override
    public void updateAndIndexComment(Comment cmt) {
        this.updateComment(cmt);
        this.createIndex(cmt);
    }

    @Override
    public Comment getComment(CommentId commentId) {
        return this.getCommentDAO().getComment(commentId);
    }

    @Override
    public List<Comment> getAllCommentsOnResource(String resourceType, ResourceReference resourceRef) {
        return this.getCommentDAO().getAllCommentsByForeignKey(resourceType, new ResourceReference((WAPrimaryKey)resourceRef));
    }

    @Override
    public List<CommentedPublicationInfo> getMostCommentedPublicationsInfo(String resourceType, List<ResourceReference> resourceRefs) {
        return this.getCommentDAO().getMostCommentedPublications(resourceType, resourceRefs);
    }

    @Override
    public List<CommentedPublicationInfo> getMostCommentedPublicationsInfo(String resourceType) {
        return this.getCommentDAO().getMostCommentedPublications(resourceType);
    }

    @Override
    public List<CommentedPublicationInfo> getAllMostCommentedPublicationsInfo() {
        return this.getCommentDAO().getAllMostCommentedPublications();
    }

    @Override
    public int getCommentsCountOnResource(String resourceType, ResourceReference ref) {
        return this.getCommentDAO().getCommentsCountByForeignKey(resourceType, ref);
    }

    @Override
    public Map<ResourceReference, Integer> getCommentCountIndexedByResource(String resourceType, String instanceId) {
        return this.getCommentDAO().getCommentCountIndexedByResource(resourceType, instanceId);
    }

    @Override
    public void indexAllCommentsOnPublication(String resourceType, ResourceReference ref) {
        List<Comment> vComments = this.getCommentDAO().getAllCommentsByForeignKey(resourceType, ref);
        for (Comment comment : vComments) {
            this.createIndex(comment);
        }
    }

    @Override
    public void unindexAllCommentsOnPublication(String resourceType, ResourceReference ref) {
        List<Comment> vComments = this.getCommentDAO().getAllCommentsByForeignKey(resourceType, ref);
        for (Comment comment : vComments) {
            this.deleteIndex(comment);
        }
    }

    private void createIndex(Comment cmt) {
        String commentMessage = cmt.getMessage();
        String component = cmt.getIdentifier().getComponentInstanceId();
        String resId = cmt.getResourceReference().getLocalId();
        try {
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(component, "Comment", cmt.getIdentifier().getLocalId(), resId));
            indexEntry.setCreationDate(cmt.getCreationDate());
            indexEntry.setCreationUser(cmt.getCreatorId());
            indexEntry.setTitle("");
            indexEntry.setPreview(commentMessage);
            indexEntry.addTextContent(commentMessage);
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private void deleteIndex(Comment comment) {
        String componentId = comment.getIdentifier().getComponentInstanceId();
        try {
            IndexEntryKey indexEntry = new IndexEntryKey(componentId, "Comment", comment.getIdentifier().getLocalId(), comment.getResourceReference().getLocalId());
            IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    protected OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    @Override
    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    @Override
    public List<Comment> getLastComments(String resourceType, int count) {
        return this.getCommentDAO().getLastComments(resourceType, count);
    }

    @Override
    public List<SocialInformationComment> getSocialInformationCommentsListByUserId(List<String> resourceTypes, String userId, Period period) {
        return this.getCommentDAO().getSocialInformationCommentsListByUserId(resourceTypes, userId, period);
    }

    @Override
    public List<SocialInformationComment> getSocialInformationCommentsListOfMyContacts(List<String> resourceTypes, List<String> myContactsIds, List<String> instanceIds, Period period) {
        return this.getCommentDAO().getSocialInformationCommentsListOfMyContacts(resourceTypes, myContactsIds, instanceIds, period);
    }

    @Transactional
    public void delete(String componentInstanceId) {
        this.getCommentDAO().removeAllCommentsByForeignPk(null, new ResourceReference(null, componentInstanceId));
    }
}

