/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLburpRequest;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LburpOperationRequest
extends LDAPExtendedOperation {
    int currSize;

    public LburpOperationRequest(LDAPLburpRequest[] op, int seqNumber) throws LDAPException {
        super("2.16.840.1.113719.1.142.100.6", null);
        try {
            ByteArrayOutputStream encodedData = new ByteArrayOutputStream();
            LBEREncoder encoder = new LBEREncoder();
            ASN1Sequence asn1_lburpPack = new ASN1Sequence();
            ASN1Integer asn1_seqNumber = new ASN1Integer(seqNumber);
            asn1_lburpPack.add(asn1_seqNumber);
            this.currSize = 0;
            while (this.currSize < op.length && op[this.currSize] != null) {
                ASN1Sequence asn1_ldapOp = new ASN1Sequence();
                switch (op[this.currSize].opType) {
                    case 6: 
                    case 8: 
                    case 12: {
                        ASN1Sequence asn1_ops = op[this.currSize].getRequestASN1Sequence();
                        asn1_ldapOp.add(asn1_ops);
                        break;
                    }
                    case 10: {
                        ASN1OctetString asn1_dops = op[this.currSize].getRequestASN1OcString();
                        ASN1Identifier asn1_tag = new ASN1Identifier(0, true, 10);
                        asn1_ldapOp.add(asn1_dops);
                        break;
                    }
                }
                ASN1SequenceOf asn1_ldapControl = op[this.currSize].getControlsASN1Object();
                if (asn1_ldapControl != null) {
                    asn1_ldapOp.add(asn1_ldapControl);
                }
                ++this.currSize;
                asn1_lburpPack.add(asn1_ldapOp);
            }
            asn1_lburpPack.encode(encoder, encodedData);
            this.setValue(encodedData.toByteArray());
        }
        catch (IOException ioe) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }

    static {
        try {
            LDAPExtendedResponse.register("2.16.840.1.113719.1.142.100.7", Class.forName("com.novell.ldap.extensions.LburpOperationResponse"));
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not register Extended Response - Class not found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

