/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class GetReplicaInfoResponse
extends LDAPExtendedResponse {
    private int partitionID;
    private int replicaState;
    private int modificationTime;
    private int purgeTime;
    private int localPartitionID;
    private String partitionDN;
    private int replicaType;
    private int flags;

    public GetReplicaInfoResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getResultCode() == 0) {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ByteArrayInputStream currentPtr = new ByteArrayInputStream(returnedValue);
            ASN1Integer asn1_partitionID = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_partitionID == null) {
                throw new IOException("Decoding error");
            }
            this.partitionID = asn1_partitionID.intValue();
            ASN1Integer asn1_replicaState = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_replicaState == null) {
                throw new IOException("Decoding error");
            }
            this.replicaState = asn1_replicaState.intValue();
            ASN1Integer asn1_modificationTime = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_modificationTime == null) {
                throw new IOException("Decoding error");
            }
            this.modificationTime = asn1_modificationTime.intValue();
            ASN1Integer asn1_purgeTime = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_purgeTime == null) {
                throw new IOException("Decoding error");
            }
            this.purgeTime = asn1_purgeTime.intValue();
            ASN1Integer asn1_localPartitionID = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_localPartitionID == null) {
                throw new IOException("Decoding error");
            }
            this.localPartitionID = asn1_localPartitionID.intValue();
            ASN1OctetString asn1_partitionDN = (ASN1OctetString)decoder.decode(currentPtr);
            if (asn1_partitionDN == null) {
                throw new IOException("Decoding error");
            }
            this.partitionDN = asn1_partitionDN.stringValue();
            if (this.partitionDN == null) {
                throw new IOException("Decoding error");
            }
            ASN1Integer asn1_replicaType = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_replicaType == null) {
                throw new IOException("Decoding error");
            }
            this.replicaType = asn1_replicaType.intValue();
            ASN1Integer asn1_flags = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_flags == null) {
                throw new IOException("Decoding error");
            }
            this.flags = asn1_flags.intValue();
        } else {
            this.partitionID = 0;
            this.replicaState = 0;
            this.modificationTime = 0;
            this.purgeTime = 0;
            this.localPartitionID = 0;
            this.partitionDN = "";
            this.replicaType = 0;
            this.flags = 0;
        }
    }

    public int getpartitionID() {
        return this.partitionID;
    }

    public int getreplicaState() {
        return this.replicaState;
    }

    public int getmodificationTime() {
        return this.modificationTime;
    }

    public int getpurgeTime() {
        return this.purgeTime;
    }

    public int getlocalPartitionID() {
        return this.localPartitionID;
    }

    public String getpartitionDN() {
        return this.partitionDN;
    }

    public int getreplicaType() {
        return this.replicaType;
    }

    public int getflags() {
        return this.flags;
    }
}

