/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service.coordination.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.ContainerType;
import com.sun.portal.container.ContainerUtil;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletEvent;
import com.sun.portal.container.PortletType;
import com.sun.portal.container.PortletWindowContextException;
import com.sun.portal.container.service.EventHolder;
import com.sun.portal.container.service.PublicRenderParameterHolder;
import com.sun.portal.container.service.ServiceAdapter;
import com.sun.portal.container.service.ServiceException;
import com.sun.portal.container.service.ServiceManager;
import com.sun.portal.container.service.coordination.ContainerEventService;
import com.sun.portal.container.service.coordination.CoordinationService;
import com.sun.portal.container.service.coordination.CoordinationSubscriber;
import com.sun.portal.container.service.deployment.DeploymentService;
import com.sun.portal.container.service.policy.DistributionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationServiceImpl
extends ServiceAdapter
implements CoordinationService {
    private static Logger logger = ContainerLogger.getLogger(CoordinationServiceImpl.class, "CLogMessages");
    private Map<ContainerType, CoordinationSubscriber> subscribers;
    private static final String DESCRIPTION = "Responsible for sending events and render parameters to all the registered subscribers";

    @Override
    public void init(ServletContext context) {
        if (this.subscribers == null) {
            this.subscribers = new ConcurrentHashMap<ContainerType, CoordinationSubscriber>();
        }
    }

    @Override
    public String getName() {
        return "com.sun.portal.container.service.CoordinationService";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void destroy() {
        this.subscribers = null;
    }

    @Override
    public List<EntityID> publishEvent(ContainerRequest containerRequest, ContainerResponse containerResponse, Queue<PortletEvent> eventQueue) throws ServiceException {
        if (eventQueue == null) {
            return Collections.emptyList();
        }
        int eventGeneration = 0;
        ArrayList<EntityID> updatedPortlets = new ArrayList<EntityID>();
        return this.publishEventInternal(containerRequest, containerResponse, eventQueue, updatedPortlets, eventGeneration);
    }

    @Override
    public void setRenderParameters(ContainerRequest containerRequest, ContainerResponse containerResponse, EntityID portletEntityId, Map<String, String[]> renderParameters) {
        CoordinationSubscriber renderParameterSubscriber;
        DeploymentService deploymentServiceForPublishPortlet = this.getDeploymentService(portletEntityId);
        if (deploymentServiceForPublishPortlet != null) {
            List<PublicRenderParameterHolder> supportedPRPHoldersFromPublishPortlet = deploymentServiceForPublishPortlet.getSupportedPublicRenderParameterHolders(containerRequest.getPortletWindowContext(), portletEntityId, renderParameters);
            if (renderParameters != null && supportedPRPHoldersFromPublishPortlet != null && !supportedPRPHoldersFromPublishPortlet.isEmpty()) {
                List<EntityID> processPortletList;
                block10: {
                    processPortletList = null;
                    try {
                        DistributionType distributionType = ContainerUtil.getPublicRenderParameterDistributionType(containerRequest);
                        processPortletList = containerRequest.getPortletWindowContext().getPortletWindows(PortletType.ALL, distributionType);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "PSC_CSPCS027", new Object[]{processPortletList, distributionType});
                        }
                    }
                    catch (PortletWindowContextException pwce) {
                        if (!logger.isLoggable(Level.SEVERE)) break block10;
                        LogRecord logRecord = new LogRecord(Level.SEVERE, "PSC_CSPCS013");
                        logRecord.setParameters(new Object[]{portletEntityId});
                        logRecord.setThrown(pwce);
                        logRecord.setLoggerName(logger.getName());
                        logger.log(logRecord);
                    }
                }
                if (processPortletList != null) {
                    DeploymentService deploymentServiceForProcessPortlet = null;
                    for (EntityID processPortletEntityId : processPortletList) {
                        CoordinationSubscriber renderParameterSubscriber2;
                        deploymentServiceForProcessPortlet = this.getDeploymentService(processPortletEntityId);
                        if (deploymentServiceForProcessPortlet == null) continue;
                        HashMap<String, String[]> prpMapForProcessPortlet = new HashMap<String, String[]>();
                        boolean supportsPRP = false;
                        Map<String, String> supportedPRPIdentifiersFromProcessPortlet = deploymentServiceForProcessPortlet.verifySupportedPublicRenderParameters(containerRequest.getPortletWindowContext(), processPortletEntityId, supportedPRPHoldersFromPublishPortlet);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "PSC_CSPCS028", new Object[]{processPortletEntityId, supportedPRPHoldersFromPublishPortlet, supportedPRPIdentifiersFromProcessPortlet});
                        }
                        Set<Map.Entry<String, String>> supportedPRPIdentifiersSet = supportedPRPIdentifiersFromProcessPortlet.entrySet();
                        for (Map.Entry<String, String> identifierPair : supportedPRPIdentifiersSet) {
                            supportsPRP = true;
                            if (!renderParameters.containsKey(identifierPair.getKey())) continue;
                            String[] values = renderParameters.get(identifierPair.getKey());
                            prpMapForProcessPortlet.put(identifierPair.getValue(), values);
                        }
                        if (!supportsPRP || (renderParameterSubscriber2 = this.getCoordinationSubscriber(processPortletEntityId)) == null) continue;
                        renderParameterSubscriber2.processRenderParameters(containerRequest, containerResponse, processPortletEntityId, prpMapForProcessPortlet, true);
                    }
                }
            }
        }
        if ((renderParameterSubscriber = this.getCoordinationSubscriber(portletEntityId)) != null) {
            renderParameterSubscriber.processRenderParameters(containerRequest, containerResponse, portletEntityId, renderParameters, false);
        }
    }

    @Override
    public void registerSubscriber(ContainerType containerType, CoordinationSubscriber coordinationSubscriber) {
        if (!this.subscribers.containsKey(containerType)) {
            this.subscribers.put(containerType, coordinationSubscriber);
        }
    }

    private List<EntityID> publishEventInternal(ContainerRequest containerRequest, ContainerResponse containerResponse, Queue<PortletEvent> eventQueue, List<EntityID> updatedPortlets, int eventGeneration) throws ServiceException {
        if (eventGeneration == ContainerUtil.getMaxEventGeneration()) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "PSC_CSPCS011", String.valueOf(eventGeneration));
            }
            return updatedPortlets;
        }
        ++eventGeneration;
        List<EntityID> portletList = null;
        try {
            DistributionType distributionType = ContainerUtil.getEventDistributionType(containerRequest);
            portletList = containerRequest.getPortletWindowContext().getPortletWindows(PortletType.ALL, distributionType);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "PSC_CSPCS026", new Object[]{portletList, distributionType});
            }
        }
        catch (PortletWindowContextException pwce) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, "PSC_CSPCS014");
                logRecord.setThrown(pwce);
                logRecord.setLoggerName(logger.getName());
                logger.log(logRecord);
            }
            return updatedPortlets;
        }
        ConcurrentLinkedQueue<PortletEvent> nextEventQueue = null;
        for (CoordinationSubscriber eventSubscriber : this.subscribers.values()) {
            ConcurrentLinkedQueue<PortletEvent> localQueue = new ConcurrentLinkedQueue<PortletEvent>();
            for (PortletEvent portletEvent : eventQueue) {
                localQueue.add(portletEvent);
            }
            while (!localQueue.isEmpty()) {
                LogRecord logRecord;
                PortletEvent currentEvent = (PortletEvent)localQueue.poll();
                ConcurrentHashMap<EntityID, QName> portletsProcessingEventQNames = new ConcurrentHashMap<EntityID, QName>();
                ArrayList<EntityID> eventProcessingPortletList = new ArrayList<EntityID>();
                for (EntityID portletEntityIdInList : portletList) {
                    if (this.isContainerEvent(currentEvent.getEventHolder()) && containerRequest.getEntityID() != null && !containerRequest.getEntityID().equals(portletEntityIdInList)) continue;
                    DeploymentService deploymentServiceForPublishPortlet = this.getDeploymentService(portletEntityIdInList);
                    EventHolder eventHolder = deploymentServiceForPublishPortlet.verifySupportedProcessingEvent(containerRequest.getPortletWindowContext(), portletEntityIdInList, currentEvent.getEventHolder());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "PSC_CSPCS029", new Object[]{portletEntityIdInList, currentEvent.getEventHolder(), eventHolder});
                    }
                    if (eventHolder == null) continue;
                    portletsProcessingEventQNames.put(portletEntityIdInList, eventHolder.getQName());
                    eventProcessingPortletList.add(portletEntityIdInList);
                }
                try {
                    Queue<PortletEvent> eventNext = eventSubscriber.processEvent(containerRequest, containerResponse, portletsProcessingEventQNames, currentEvent);
                    if (eventNext != null) {
                        if (nextEventQueue == null) {
                            nextEventQueue = new ConcurrentLinkedQueue<PortletEvent>();
                        }
                        for (PortletEvent event : eventNext) {
                            nextEventQueue.add(event);
                        }
                    }
                    updatedPortlets.addAll(eventProcessingPortletList);
                }
                catch (ContentException ex) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logRecord = new LogRecord(Level.SEVERE, "PSC_CSPCS009");
                    logRecord.setParameters(new Object[]{currentEvent.getName()});
                    logRecord.setThrown(ex);
                    logRecord.setLoggerName(logger.getName());
                    logger.log(logRecord);
                }
                catch (ContainerException ex) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logRecord = new LogRecord(Level.SEVERE, "PSC_CSPCS009");
                    logRecord.setParameters(new Object[]{currentEvent.getName()});
                    logRecord.setThrown(ex);
                    logRecord.setLoggerName(logger.getName());
                    logger.log(logRecord);
                }
            }
        }
        if (nextEventQueue != null) {
            updatedPortlets = this.publishEventInternal(containerRequest, containerResponse, nextEventQueue, updatedPortlets, eventGeneration);
        }
        return updatedPortlets;
    }

    private boolean isContainerEvent(EventHolder currentEventHolder) {
        return this.getContainerEventService() != null && this.getContainerEventService().getSupportedEvents().contains(currentEventHolder);
    }

    private ContainerEventService getContainerEventService() {
        return (ContainerEventService)ContainerUtil.getService("com.sun.portal.container.service.ContainerEventService");
    }

    private DeploymentService getDeploymentService(EntityID entityId) {
        DeploymentService deploymentService = null;
        deploymentService = entityId.getPortletID() != null ? (DeploymentService)ServiceManager.getServiceManager().getService("com.sun.portal.container.service.DeploymentService_Local") : (DeploymentService)ServiceManager.getServiceManager().getService("com.sun.portal.container.service.DeploymentService_Remote");
        return deploymentService;
    }

    private CoordinationSubscriber getCoordinationSubscriber(EntityID entityId) {
        CoordinationSubscriber subscriber = null;
        subscriber = entityId.getPortletID() != null ? this.subscribers.get(ContainerType.PORTLET_CONTAINER) : this.subscribers.get(ContainerType.WSRP_CONSUMER);
        return subscriber;
    }
}

