/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container;

import com.sun.portal.container.PortletID;
import java.io.Serializable;

public class EntityID
implements Serializable {
    private PortletID portletID;
    private String portletWindowName;
    private static final String ENTITY_ID_DELIMITER = "|";

    public EntityID() {
    }

    public EntityID(PortletID portletID) {
        this.portletID = portletID;
    }

    public PortletID getPortletID() {
        return this.portletID;
    }

    public void setPrefix(String entityIDPrefix) {
        if (entityIDPrefix != null) {
            int index = entityIDPrefix.indexOf(ENTITY_ID_DELIMITER);
            if (index != -1) {
                String portletApplicationName = entityIDPrefix.substring(0, index);
                String portletName = entityIDPrefix.substring(index + 1);
                this.portletID = new PortletID(portletApplicationName, portletName);
            } else {
                throw new IllegalArgumentException("The EntityID Prefix should be of the form PortletApplicationName|PortletName");
            }
        }
    }

    public String getPrefix() {
        return this.getPrefix(this.portletID.getPortletApplicationName(), this.portletID.getPortletName());
    }

    public String getPortletApplicationName() {
        if (this.portletID != null) {
            return this.portletID.getPortletApplicationName();
        }
        return null;
    }

    public String getPortletName() {
        if (this.portletID != null) {
            return this.portletID.getPortletName();
        }
        return null;
    }

    public String getPortletWindowName() {
        return this.portletWindowName;
    }

    public void setPortletWindowName(String portletWindowName) {
        this.portletWindowName = portletWindowName;
    }

    public String toString() {
        if (this.portletID != null) {
            return this.getEntityId(this.portletID, this.portletWindowName);
        }
        return this.portletWindowName;
    }

    private String getPrefix(String portletAppName, String portletName) {
        String entityIDPrefix = EntityID.getString(portletAppName, ENTITY_ID_DELIMITER, portletName);
        return entityIDPrefix;
    }

    private String getEntityId(PortletID portletID, String portletWindowName) {
        String entityID = EntityID.getString(this.getPrefix(portletID.getPortletApplicationName(), portletID.getPortletName()), ENTITY_ID_DELIMITER, portletWindowName);
        return entityID;
    }

    private static String getString(String ... params) {
        StringBuffer buffer = new StringBuffer();
        for (String param : params) {
            buffer.append(param);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityID other = (EntityID)obj;
        if (!(this.portletID == other.portletID || this.portletID != null && this.portletID.equals(other.portletID))) {
            return false;
        }
        return this.portletWindowName == other.portletWindowName || this.portletWindowName != null && this.portletWindowName.equals(other.portletWindowName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.portletID != null ? this.portletID.hashCode() : 0);
        hash = 17 * hash + (this.portletWindowName != null ? this.portletWindowName.hashCode() : 0);
        return hash;
    }
}

