/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import com.google.api.client.util.SslUtils;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.silverpeas.kernel.util.StringUtil;
import org.silverpeas.kernel.util.SystemWrapper;

public class HttpUtil {
    private HttpUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static HttpClient httpClient() {
        return HttpUtil.httpClient(null);
    }

    public static HttpClient httpClientTrustingAnySslContext() throws GeneralSecurityException {
        return HttpUtil.httpClient(SslUtils.trustAllSSLContext());
    }

    public static HttpClient httpClient(SSLContext sslContext) {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
        if (sslContext != null) {
            builder = builder.sslContext(sslContext);
        }
        String proxyHost = SystemWrapper.getInstance().getProperty("http.proxyHost");
        String proxyPort = SystemWrapper.getInstance().getProperty("http.proxyPort");
        if (StringUtil.isDefined((String)proxyHost) && StringUtil.isInteger((String)proxyPort)) {
            builder = builder.proxy(ProxySelector.of(new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort))));
        }
        return builder.build();
    }

    public static HttpRequest.Builder toUrl(String url) {
        return HttpUtil.toUri(URI.create(url));
    }

    public static HttpRequest.Builder toUri(URI uri) {
        return HttpRequest.newBuilder().uri(uri);
    }
}

