/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.util.Collection;
import java.util.HashSet;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.subscription.ResourceSubscriptionService;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.ComponentSubscriptionResource;
import org.silverpeas.core.subscription.service.NodeSubscriptionResource;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;

public abstract class AbstractResourceSubscriptionService
implements ResourceSubscriptionService,
Initialization {
    public void init() {
        ResourceSubscriptionProvider.registerResourceSubscriptionService(this);
    }

    protected abstract String getHandledComponentName();

    @Override
    public SubscriptionSubscriberList getSubscribersOfComponent(String componentInstanceId) {
        return this.getSubscribersOfComponentAndTypedResource(componentInstanceId, CommonSubscriptionResourceConstants.COMPONENT, null, new SubscriberDirective[0]);
    }

    @Override
    public SubscriptionSubscriberList getSubscribersOfSubscriptionResource(SubscriptionResource subscriptionResource, SubscriberDirective ... directives) {
        return this.getSubscribersOfComponentAndTypedResource(subscriptionResource.getInstanceId(), subscriptionResource.getType(), subscriptionResource.getId(), directives);
    }

    @Override
    public SubscriptionSubscriberList getSubscribersOfComponentAndTypedResource(String componentInstanceId, SubscriptionResourceType resourceType, String resourceId, SubscriberDirective ... directives) {
        HashSet<SubscriptionSubscriber> subscribers = new HashSet<SubscriptionSubscriber>();
        if (CommonSubscriptionResourceConstants.NODE == resourceType) {
            NodePath path = !"kmax".equals(componentInstanceId) ? this.getNodeService().getPath(new NodePK(resourceId, componentInstanceId)) : null;
            this.addAllSubscribersAboutNodePath(path, subscribers);
            this.addAllSubscribersAboutComponentInstance(componentInstanceId, subscribers);
        } else if (CommonSubscriptionResourceConstants.COMPONENT == resourceType) {
            this.addAllSubscribersAboutComponentInstance(componentInstanceId, subscribers);
        }
        return new SubscriptionSubscriberList((Collection<? extends SubscriptionSubscriber>)subscribers);
    }

    private void addAllSubscribersAboutComponentInstance(String componentInstanceId, Collection<SubscriptionSubscriber> subscribers) {
        subscribers.addAll(SubscriptionServiceProvider.getSubscribeService().getSubscribers(ComponentSubscriptionResource.from(componentInstanceId)));
    }

    protected void addAllSubscribersAboutNodePath(NodePath nodePath, Collection<SubscriptionSubscriber> subscribers) {
        if (nodePath != null) {
            for (NodeDetail node : nodePath) {
                subscribers.addAll(SubscriptionServiceProvider.getSubscribeService().getSubscribers(NodeSubscriptionResource.from(node.getNodePK())));
            }
        }
    }

    protected NodeService getNodeService() {
        return NodeService.get();
    }
}

