/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.provider;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;

public interface SocialInformationProviderSwitcher {
    public List<SocialInformation> getSocialInformationsList(SocialInformationType var1, SocialInfoContext var2);

    public List<SocialInformation> getSocialInformationsListOfMyContacts(SocialInformationType var1, SocialInfoContext var2);

    public static class SocialInfoContext {
        private final String userId;
        private final Date begin;
        private final Date end;
        private List<String> contactIds = null;
        private String classification = "";

        public SocialInfoContext(String userId, Period period) {
            this.userId = userId;
            this.begin = TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)period.getStartDate()).atZoneSameInstant(ZoneId.systemDefault()));
            this.end = TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)period.getEndDate()).atZoneSameInstant(ZoneId.systemDefault()));
        }

        public SocialInfoContext withContactIds(List<String> contactIds) {
            this.contactIds = contactIds;
            return this;
        }

        public SocialInfoContext withClassification(String classification) {
            this.classification = classification;
            return this;
        }

        public String getUserId() {
            return this.userId;
        }

        public Date getBeginDate() {
            return this.begin;
        }

        public Date getEndDate() {
            return this.end;
        }

        public List<String> getContactIds() {
            return this.contactIds;
        }

        public String getClassification() {
            return this.classification;
        }
    }
}

