/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.model;

import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public enum SocialNetworkID {
    FACEBOOK,
    LINKEDIN,
    UNKNOWN;

    private static final SettingBundle settings;

    public boolean isEnabled() {
        switch (this) {
            case FACEBOOK: {
                return settings.getBoolean("facebook.enable", false);
            }
            case LINKEDIN: {
                return settings.getBoolean("linkedIn.enable", false);
            }
        }
        return false;
    }

    public static boolean oneIsEnable() {
        for (SocialNetworkID socialNetworkId : SocialNetworkID.values()) {
            if (!socialNetworkId.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public static SocialNetworkID from(String socialNetworkId) {
        if (StringUtil.isDefined((String)socialNetworkId)) {
            if (socialNetworkId.equalsIgnoreCase(FACEBOOK.name())) {
                return FACEBOOK;
            }
            if (socialNetworkId.equalsIgnoreCase(LINKEDIN.name())) {
                return LINKEDIN;
            }
        }
        return UNKNOWN;
    }

    static {
        settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.social.settings.socialNetworkSettings");
    }
}

