/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.invitation;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.socialnetwork.invitation.AcceptationUserNotification;
import org.silverpeas.core.socialnetwork.invitation.Invitation;
import org.silverpeas.core.socialnetwork.invitation.InvitationDao;
import org.silverpeas.core.socialnetwork.invitation.NewInvitationUserNotification;
import org.silverpeas.core.socialnetwork.relationship.RelationShip;
import org.silverpeas.core.socialnetwork.relationship.RelationShipDao;
import org.silverpeas.core.socialnetwork.relationship.RelationShipEventNotifier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class InvitationService {
    public static final int INVITATION_ALREADY_EXISTING = -1;
    public static final int RELATIONSHIP_ALREADY_EXISTING = -2;
    public static final int INVITATION_NOT_EXISTING = -1;
    @Inject
    private InvitationDao invitationDao;
    @Inject
    private RelationShipDao relationShipDao;
    @Inject
    private RelationShipEventNotifier relationShipEventNotifier;

    InvitationService() {
    }

    public static InvitationService get() {
        return (InvitationService)ServiceProvider.getService(InvitationService.class, (Annotation[])new Annotation[0]);
    }

    public int invite(Invitation invitation) {
        int newId = (Integer)Transaction.performInOne(() -> this.saveInvitation(invitation));
        if (newId != -1 && newId != -2) {
            this.notifyGuest(invitation);
        }
        return newId;
    }

    private int saveInvitation(Invitation invitation) {
        int invitationResult = 0;
        try (Connection connection = this.getConnection();){
            boolean alreadySent = this.invitationDao.isExists(connection, invitation.getSenderId(), invitation.getReceiverId());
            invitationResult = alreadySent ? -1 : (this.relationShipDao.isInRelationShip(connection, invitation.getSenderId(), invitation.getReceiverId()) ? -2 : this.invitationDao.createInvitation(connection, invitation));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return invitationResult;
    }

    @Transactional
    public void ignoreInvitation(int id) {
        try (Connection connection = this.getConnection();){
            this.invitationDao.deleteInvitation(connection, id);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    public int acceptInvitation(int idInvitation) {
        Pair result = (Pair)Transaction.performInOne(() -> this.saveAcceptInvitation(idInvitation));
        int resultAcceptInvitation = (Integer)((Pair)result.getLeft()).getLeft();
        if (resultAcceptInvitation > 0) {
            Invitation invitation = (Invitation)((Pair)result.getLeft()).getRight();
            RelationShip ship1 = (RelationShip)((Pair)result.getRight()).getLeft();
            RelationShip ship2 = (RelationShip)((Pair)result.getRight()).getRight();
            if (ship1 != null) {
                for (RelationShip ship : Arrays.asList(ship1, ship2)) {
                    this.relationShipEventNotifier.notifyEventOn(ResourceEvent.Type.CREATION, new RelationShip[]{ship});
                }
            }
            this.alertAcceptation(invitation);
        }
        return resultAcceptInvitation;
    }

    private Pair<Pair<Integer, Invitation>, Pair<RelationShip, RelationShip>> saveAcceptInvitation(int idInvitation) {
        int resultAcceptInvitation;
        Invitation invitation = null;
        RelationShip ship1 = null;
        RelationShip ship2 = null;
        try (Connection connection = this.getConnection();){
            invitation = this.invitationDao.getInvitation(connection, idInvitation);
            if (invitation == null) {
                resultAcceptInvitation = -1;
            } else if (this.relationShipDao.isInRelationShip(connection, invitation.getSenderId(), invitation.getReceiverId())) {
                resultAcceptInvitation = -2;
            } else {
                ship1 = new RelationShip();
                ship1.setUser1Id(invitation.getSenderId());
                ship1.setUser2Id(invitation.getReceiverId());
                ship1.setAcceptanceDate(new Timestamp(new Date().getTime()));
                ship1.setInviterId(invitation.getSenderId());
                ship2 = new RelationShip();
                ship2.setUser1Id(invitation.getReceiverId());
                ship2.setUser2Id(invitation.getSenderId());
                ship2.setAcceptanceDate(new Timestamp(new Date().getTime()));
                ship2.setInviterId(invitation.getSenderId());
                this.invitationDao.deleteSameInvitations(connection, idInvitation);
                resultAcceptInvitation = this.relationShipDao.createRelationShip(connection, ship1);
                this.relationShipDao.createRelationShip(connection, ship2);
            }
        }
        catch (Exception ex) {
            resultAcceptInvitation = 0;
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return Pair.of((Object)Pair.of((Object)resultAcceptInvitation, (Object)invitation), (Object)Pair.of(ship1, ship2));
    }

    public List<Invitation> getAllMyInvitationsSent(int userId) {
        List<Invitation> invitations = new ArrayList<Invitation>();
        try (Connection connection = this.getConnection();){
            invitations = this.invitationDao.getAllMyInvitationsSent(connection, userId);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return invitations;
    }

    public List<Invitation> getAllMyInvitationsReceive(int myId) {
        List<Invitation> invitations = new ArrayList<Invitation>();
        try (Connection connection = this.getConnection();){
            invitations = this.invitationDao.getAllMyInvitationsReceive(connection, myId);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return invitations;
    }

    public Invitation getInvitation(int id) {
        Invitation invitation;
        block8: {
            Connection connection = this.getConnection();
            try {
                invitation = this.invitationDao.getInvitation(connection, id);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
                    return null;
                }
            }
            connection.close();
        }
        return invitation;
    }

    public Invitation getInvitation(int senderId, int receiverId) {
        Invitation invitation;
        block8: {
            Connection connection = this.getConnection();
            try {
                invitation = this.invitationDao.getInvitation(connection, senderId, receiverId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
                    return null;
                }
            }
            connection.close();
        }
        return invitation;
    }

    @Transactional
    public void deleteAllMyInvitations(String userId) {
        try (Connection connection = this.getConnection();){
            this.invitationDao.deleteAllInvitations(connection, Integer.parseInt(userId));
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private Connection getConnection() throws SQLException {
        return DBUtil.openConnection();
    }

    private void alertAcceptation(Invitation invitation) {
        UserNotificationHelper.buildAndSend(new AcceptationUserNotification(invitation));
    }

    private void notifyGuest(Invitation invitation) {
        UserNotificationHelper.buildAndSend(new NewInvitationUserNotification(invitation));
    }
}

