/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.UserSpaceAvailabilityChecker;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authorization.AbstractAccessController;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.SpaceAccessControl;

@Service
@Singleton
public class SpaceAccessController
extends AbstractAccessController<String>
implements SpaceAccessControl {
    private static final String LIGHT_ROLE_COMPUTING = "light_role_computing";
    private static final String DATA_MANAGER_CONTEXT_KEY = "SpaceAccessControllerDataManager";

    SpaceAccessController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserAuthorized(String userId, String spaceId, AccessControlContext context) {
        context.put(LIGHT_ROLE_COMPUTING, (Object)true);
        try {
            boolean bl = this.isUserAuthorized(this.getUserRoles(userId, spaceId, context));
            return bl;
        }
        finally {
            context.put(LIGHT_ROLE_COMPUTING, null);
        }
    }

    @Override
    public Stream<String> filterAuthorizedByUser(Collection<String> spaceIds, String userId, AccessControlContext context) {
        SpaceAccessController.getDataManager(context).loadCaches(userId, spaceIds);
        return spaceIds.stream().filter(s -> this.isUserAuthorized(userId, (String)s, context));
    }

    @Override
    protected void fillUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, String spaceId) {
        DataManager dataManager = SpaceAccessController.getDataManager(context);
        if (!AccessControlOperation.isPersistActionFrom((Collection)context.getOperations()) && dataManager.isSpaceAvailableToUser(spaceId, userId)) {
            if (Boolean.TRUE.equals(context.get(LIGHT_ROLE_COMPUTING, Boolean.class))) {
                userRoles.add(SilverpeasRole.USER);
            } else {
                userRoles.addAll(dataManager.getSpaceUserRoles(spaceId, userId));
                userRoles.remove(SilverpeasRole.MANAGER);
                if (userRoles.isEmpty()) {
                    userRoles.add(SilverpeasRole.USER);
                }
            }
        } else if (context.getOperations().contains(AccessControlOperation.MODIFICATION) && (dataManager.getUser(userId).isAccessAdmin() || dataManager.getManageableSpaceIds(userId).contains(spaceId.replace("WA", "")))) {
            userRoles.add(SilverpeasRole.MANAGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUserSpaceManagementAuthorization(String userId, String spaceId, AccessControlContext context) {
        boolean bl;
        block3: {
            boolean hasAddedModificationOperation = !context.getOperations().contains(AccessControlOperation.MODIFICATION);
            context.onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION});
            try {
                bl = this.getUserRoles(userId, spaceId, context).contains(SilverpeasRole.MANAGER);
                if (!hasAddedModificationOperation) break block3;
            }
            catch (Throwable throwable) {
                if (hasAddedModificationOperation) {
                    context.removeOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION});
                }
                throw throwable;
            }
            context.removeOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION});
        }
        return bl;
    }

    static DataManager getDataManager(AccessControlContext context) {
        DataManager manager = (DataManager)context.get(DATA_MANAGER_CONTEXT_KEY, DataManager.class);
        if (manager == null) {
            manager = new DataManager();
            context.put(DATA_MANAGER_CONTEXT_KEY, (Object)manager);
        }
        return manager;
    }

    public static class DataManager {
        private final OrganizationController controller;
        private UserSpaceAvailabilityChecker userSpaceAvailabilityChecker;
        private final Map<String, Set<String>> manageableSpaceIdsCache = new HashMap<String, Set<String>>(1);
        Map<String, Set<String>> spaceUserProfiles = null;

        DataManager() {
            this.controller = OrganizationController.get();
        }

        void loadCaches(String userId, Collection<String> spaceIds) {
            if (spaceIds.isEmpty()) {
                return;
            }
            this.completeCaches(userId, spaceIds);
        }

        void completeCaches(String userId, Collection<String> spaceIds) {
            boolean firstLoad;
            boolean bl = firstLoad = this.spaceUserProfiles == null;
            if (firstLoad) {
                this.spaceUserProfiles = this.controller.getSpaceUserProfilesBySpaceIds(userId, spaceIds);
            } else {
                this.spaceUserProfiles.putAll(this.controller.getSpaceUserProfilesBySpaceIds(userId, spaceIds));
            }
        }

        User getUser(String userId) {
            return User.getById((String)userId);
        }

        Collection<SilverpeasRole> getSpaceUserRoles(String spaceId, String userId) {
            Collection<String> profiles = this.spaceUserProfiles != null ? (Collection)this.spaceUserProfiles.getOrDefault(spaceId, Collections.emptySet()) : this.controller.getSpaceUserProfilesBySpaceId(userId, spaceId);
            return profiles.stream().map(SilverpeasRole::fromString).collect(Collectors.toList());
        }

        boolean isSpaceAvailableToUser(String spaceId, String userId) {
            if (this.userSpaceAvailabilityChecker == null) {
                this.userSpaceAvailabilityChecker = this.controller.getUserSpaceAvailabilityChecker(userId);
            }
            return this.userSpaceAvailabilityChecker.isAvailable(spaceId);
        }

        public Set<String> getManageableSpaceIds(String userId) {
            return this.manageableSpaceIdsCache.computeIfAbsent(userId, s -> Stream.of(this.controller.getUserManageableSpaceIds((String)s)).collect(Collectors.toSet()));
        }
    }
}

