/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.authorization.AbstractAccessController;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.ComponentAccessController;
import org.silverpeas.core.security.authorization.ComponentInstanceSimpleDocumentAccessControlExtension;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessController;
import org.silverpeas.core.security.authorization.SimpleDocumentAccessControl;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class SimpleDocumentAccessController
extends AbstractAccessController<SimpleDocument>
implements SimpleDocumentAccessControl {
    private ComponentAccessControl componentAccessController;
    private NodeAccessControl nodeAccessController;
    private PublicationAccessControl publicationAccessController;

    @Inject
    SimpleDocumentAccessController(ComponentAccessControl componentAccessController, NodeAccessControl nodeAccessController, PublicationAccessControl publicationAccessController) {
        this.componentAccessController = componentAccessController;
        this.nodeAccessController = nodeAccessController;
        this.publicationAccessController = publicationAccessController;
    }

    @Override
    public boolean isUserAuthorized(String userId, ResourceIdentifier id) {
        ContributionIdentifier docId = (ContributionIdentifier)id;
        SimpleDocumentPK docPK = new SimpleDocumentPK(docId.getLocalId(), docId.getComponentInstanceId());
        SimpleDocument doc = AttachmentService.get().searchDocumentById(docPK, null);
        return this.isUserAuthorized(userId, doc);
    }

    public boolean isUserAuthorized(String userId, SimpleDocument object, AccessControlContext context) {
        this.getComponentExtension(object.getInstanceId()).beforeComputingAuthorizations(userId, object, context);
        Set componentUserRoles = null;
        boolean componentAccessAuthorized = false;
        ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
        if (componentDataManager.isTopicTrackerSupported(object.getInstanceId())) {
            String foreignId = object.getForeignId();
            if (this.isFileAttachedToWysiwygDescriptionOfNode(foreignId)) {
                String nodeId = foreignId.substring("Node_".length());
                NodePK nodePK = new NodePK(nodeId, object.getInstanceId());
                Set parentUserRoles = this.getNodeAccessController().getUserRoles(userId, nodePK, context);
                return this.getNodeAccessController().isUserAuthorized(parentUserRoles) && this.isUserAuthorizedByContext(true, userId, object, context, parentUserRoles, "unknown");
            }
            PublicationPK pubPk = new PublicationPK(foreignId, object.getInstanceId());
            Set parentUserRoles = this.getPublicationAccessController().getUserRoles(userId, pubPk, context);
            PublicationDetail publicationDetail = PublicationAccessController.getDataManager(context).getCurrentPublication();
            if (publicationDetail != null) {
                return this.isUserAuthorizedByContext(false, userId, object, context, parentUserRoles, publicationDetail.getCreatorId());
            }
            componentUserRoles = parentUserRoles;
            componentAccessAuthorized = this.getComponentAccessController().isUserAuthorized(componentUserRoles);
        }
        if (!componentAccessAuthorized && componentUserRoles == null) {
            componentUserRoles = this.getComponentAccessController().getUserRoles(userId, (Object)object.getInstanceId(), context);
            componentAccessAuthorized = this.getComponentAccessController().isUserAuthorized(componentUserRoles);
        }
        return componentAccessAuthorized && this.isUserAuthorizedByContext(false, userId, object, context, componentUserRoles, userId);
    }

    private boolean isUserAuthorizedByContext(boolean isNodeAttachmentCase, String userId, SimpleDocument object, AccessControlContext context, Set<SilverpeasRole> userRoles, String foreignUserAuthor) {
        boolean authorized = !userRoles.isEmpty();
        boolean isRoleVerificationRequired = false;
        SilverpeasRole highestUserRole = SilverpeasRole.getHighestFrom(userRoles);
        if (highestUserRole == null) {
            highestUserRole = SilverpeasRole.READER;
        }
        boolean downloadOperation = AccessControlOperation.isDownloadActionFrom((Collection)context.getOperations());
        boolean sharingOperation = AccessControlOperation.isSharingActionFrom((Collection)context.getOperations());
        if (object.isVersioned() && !object.isPublic()) {
            isRoleVerificationRequired = true;
        }
        if (authorized && downloadOperation && !object.isDownloadAllowedForReaders()) {
            isRoleVerificationRequired = authorized = object.isDownloadAllowedForRoles(userRoles);
        }
        if (authorized && sharingOperation) {
            ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
            User user = User.getById((String)userId);
            authorized = !user.isAnonymous() && !user.isAccessGuest() && componentDataManager.isFileSharingEnabledForRole(object.getInstanceId(), highestUserRole);
            isRoleVerificationRequired = false;
        }
        if (authorized && AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
            isRoleVerificationRequired = true;
        }
        if (isRoleVerificationRequired) {
            authorized = this.verifyAuthorizationAgainstRole(highestUserRole, isNodeAttachmentCase, userId, object, foreignUserAuthor, downloadOperation, context);
        }
        return authorized;
    }

    private boolean verifyAuthorizationAgainstRole(SilverpeasRole highestUserRole, boolean isNodeAttachmentCase, String userId, SimpleDocument object, String foreignUserAuthor, boolean downloadOperation, AccessControlContext context) {
        boolean authorized;
        if (isNodeAttachmentCase) {
            authorized = downloadOperation ? highestUserRole.isGreaterThan(SilverpeasRole.WRITER) : highestUserRole.isGreaterThanOrEquals(SilverpeasRole.ADMIN);
        } else if (SilverpeasRole.WRITER.equals((Object)highestUserRole)) {
            ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
            authorized = userId.equals(foreignUserAuthor) || componentDataManager.isCoWritingEnabled(object.getInstanceId());
        } else {
            authorized = highestUserRole.isGreaterThan(SilverpeasRole.WRITER);
        }
        return authorized;
    }

    ComponentInstanceSimpleDocumentAccessControlExtension getComponentExtension(String instanceId) {
        return ComponentInstanceSimpleDocumentAccessControlExtension.getByInstanceId(instanceId);
    }

    private boolean isFileAttachedToWysiwygDescriptionOfNode(String foreignId) {
        return StringUtil.isDefined((String)foreignId) && foreignId.startsWith("Node_");
    }

    private ComponentAccessControl getComponentAccessController() {
        return this.componentAccessController;
    }

    private NodeAccessControl getNodeAccessController() {
        return this.nodeAccessController;
    }

    private PublicationAccessControl getPublicationAccessController() {
        return this.publicationAccessController;
    }
}

