/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password;

import java.util.HashMap;
import java.util.Optional;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.util.StringUtil;

public class ForgottenPasswordMailParameters {
    private static final String KEY_DOMAIN_ID = "domainId";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_ERROR = "error";
    private static final String KEY_LINK = "link";
    private static final String KEY_LOGIN = "login";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_USER_NAME = "userName";
    private static final String TEXT_LINE_SEPARATOR = "\r\n";
    private static final String HTML_LINE_SEPARATOR = "<br>";
    private final HashMap<String, String> parametersValues = new HashMap();
    private String toAddress;
    private String language;

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.parametersValues.get(KEY_MESSAGE));
    }

    public void setDomainId(String domainId) {
        this.parametersValues.put(KEY_DOMAIN_ID, domainId);
    }

    public void setEmail(String email) {
        this.parametersValues.put(KEY_EMAIL, email);
    }

    public void setError(String error) {
        this.parametersValues.put(KEY_ERROR, error);
    }

    public void setLink(String link) {
        this.parametersValues.put(KEY_LINK, link);
    }

    public void setLogin(String login) {
        this.parametersValues.put(KEY_LOGIN, login);
    }

    public void setMessage(String message) {
        this.parametersValues.put(KEY_MESSAGE, ForgottenPasswordMailParameters.replaceLineSeparators(message));
    }

    public void setPassword(String password) {
        this.parametersValues.put(KEY_PASSWORD, password);
    }

    public void setUserName(String userName) {
        this.parametersValues.put(KEY_USER_NAME, userName);
    }

    public void setUserLanguage(String lang) {
        this.language = lang;
    }

    public String getUserLanguage() {
        return StringUtil.defaultStringIfNotDefined((String)this.language, (String)DisplayI18NHelper.getDefaultLanguage());
    }

    public void applyTemplateData(SilverpeasTemplate template) {
        this.parametersValues.forEach((arg_0, arg_1) -> ((SilverpeasTemplate)template).setAttribute(arg_0, arg_1));
    }

    private static String replaceLineSeparators(String s) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            int index = s.indexOf(TEXT_LINE_SEPARATOR);
            while (index != -1) {
                sb.append(s.substring(0, index)).append(HTML_LINE_SEPARATOR);
                s = s.substring(index + TEXT_LINE_SEPARATOR.length());
                index = s.indexOf(TEXT_LINE_SEPARATOR);
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

