/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.util.ArrayList;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.notification.UserPreferenceEvent;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.kernel.logging.SilverLogger;

@Bean
public class UserPreferenceReminderListener
extends CDIResourceEventListener<UserPreferenceEvent> {
    public void onUpdate(UserPreferenceEvent event) {
        try {
            UserPreferences previous = (UserPreferences)event.getTransition().getBefore();
            UserPreferences current = (UserPreferences)event.getTransition().getAfter();
            if (!previous.getZoneId().equals(current.getZoneId())) {
                ArrayList toUnschedule = new ArrayList();
                Reminder.getByUser((User)current.getUser()).stream().filter(Reminder::isScheduled).forEach(r -> {
                    try {
                        r.schedule();
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        toUnschedule.add(r);
                        SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
                    }
                });
                toUnschedule.forEach(r -> r.unschedule(false));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
        }
    }
}

