/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.util.List;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderRepository;

@Repository
@Singleton
public class DefaultReminderRepository
extends BasicJpaEntityRepository<Reminder>
implements ReminderRepository {
    public List<Reminder> findByUserId(String id) {
        NamedParameters parameters = this.newNamedParameters().add("userId", (Object)id);
        return this.findByNamedQuery("remindersByUserId", parameters);
    }

    public List<Reminder> findByContributionId(ContributionIdentifier contributionId) {
        NamedParameters parameters = this.newNamedParameters().add("contributionId", (Object)contributionId);
        return this.findByNamedQuery("remindersByContributionId", parameters);
    }

    public List<Reminder> findByContributionAndUserIds(ContributionIdentifier contributionId, String userId) {
        NamedParameters parameters = this.newNamedParameters().add("userId", (Object)userId).add("contributionId", (Object)contributionId);
        return this.findByNamedQuery("remindersByContributionIdAndUserId", parameters);
    }
}

