/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.popup;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Map;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.channel.popup.POPUPMessageBean;
import org.silverpeas.core.notification.user.server.channel.popup.POPUPMessageBeanRepository;
import org.silverpeas.core.notification.user.server.channel.popup.PopupMessageService;
import org.silverpeas.core.notification.user.server.channel.popup.PopupMsg;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.jdbc.LongText;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class DefaultPopupMessageService
implements PopupMessageService {
    private static final String COMMUNICATION_PREFIX = "COMMUNICATION";
    private static final String ALERT_PREFIX = "ALERT";

    protected DefaultPopupMessageService() {
    }

    @Override
    public PopupMsg read(String userId) {
        PopupMsg popupMsg = null;
        POPUPMessageBean pmb = null;
        try {
            pmb = this.getRepository().findFirstMessageByUserId(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot read message for user {0}", (Object[])new String[]{userId}, (Throwable)e);
        }
        if (pmb != null) {
            String msg = null;
            try {
                String body2 = pmb.getBody();
                if (body2.startsWith(COMMUNICATION_PREFIX)) {
                    body2 = body2.substring(COMMUNICATION_PREFIX.length());
                }
                int longTextId = Integer.parseInt(body2);
                msg = LongText.getLongText((int)longTextId);
            }
            catch (NumberFormatException nfe) {
                msg = pmb.getBody();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot read message for user {0}", (Object[])new String[]{userId}, (Throwable)e);
            }
            if (msg != null) {
                popupMsg = pmb.getBody().startsWith(COMMUNICATION_PREFIX) ? new PopupMsg(COMMUNICATION_PREFIX) : new PopupMsg(ALERT_PREFIX);
                popupMsg.setContent(msg);
                popupMsg.setID(pmb.getId());
                popupMsg.setSenderId(pmb.getSenderId());
                popupMsg.setSenderName(pmb.getSenderName());
                popupMsg.setAnswerAllowed(pmb.isAnswerAllowed());
            }
        }
        return popupMsg;
    }

    @Override
    @Transactional
    public void deleteById(String msgId) {
        POPUPMessageBeanRepository repository = this.getRepository();
        POPUPMessageBean toDel = (POPUPMessageBean)repository.getById(msgId);
        if (toDel != null) {
            try {
                int longTextId = toDel.getBody().startsWith(COMMUNICATION_PREFIX) ? Integer.parseInt(toDel.getBody().substring(COMMUNICATION_PREFIX.length())) : Integer.parseInt(toDel.getBody());
                LongText.removeLongText((int)longTextId);
            }
            catch (NumberFormatException longTextId) {
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot delete message {0}", (Object[])new String[]{msgId}, (Throwable)e);
            }
            try {
                repository.delete((IdentifiableEntity[])new POPUPMessageBean[]{toDel});
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot delete message {0}", (Object[])new String[]{msgId}, (Throwable)e);
            }
        }
    }

    @Override
    @Transactional
    public void deleteAll(String userId) {
        try {
            this.getRepository().deleteMessagesByUserIdAndSenderId(userId, "-1");
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error("Cannot delete all messages for user {0}", (Object[])new String[]{userId}, (Throwable)ex);
        }
    }

    @Override
    @Transactional
    public void push(String userId, NotificationData notifMsg) {
        POPUPMessageBean pmb = new POPUPMessageBean();
        try {
            pmb.setUserId(Long.parseLong(userId));
            if (COMMUNICATION_PREFIX.equals(notifMsg.getComment())) {
                pmb.setBody(notifMsg.getComment() + Integer.toString(LongText.addLongText((String)notifMsg.getMessage())));
            } else {
                pmb.setBody(Integer.toString(LongText.addLongText((String)notifMsg.getMessage())));
            }
            Map keyValue = notifMsg.getTargetParam();
            String tmpSourceString = (String)keyValue.get("SOURCE");
            String tmpUrlString = (String)keyValue.get("URL");
            pmb.setSenderId(notifMsg.getSenderId());
            pmb.setSenderName(notifMsg.getSenderName());
            pmb.setAnswerAllowed(notifMsg.isAnswerAllowed());
            pmb.setUrl(tmpUrlString);
            pmb.setSource(tmpSourceString);
            pmb.setMsgDate(DateUtil.date2SQLDate((Date)new Date()));
            pmb.setMsgTime(DateUtil.getFormattedTime((Date)new Date()));
            this.getRepository().save((IdentifiableEntity)pmb);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot push message {0} for user {1}", new Object[]{notifMsg, userId}, (Throwable)e);
        }
    }

    private POPUPMessageBeanRepository getRepository() {
        return (POPUPMessageBeanRepository)((Object)ServiceProvider.getService(POPUPMessageBeanRepository.class, (Annotation[])new Annotation[0]));
    }
}

