/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.xml.NotifyContentHandler;
import org.silverpeas.core.util.Charsets;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NotificationServerUtil {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static final String DATE_TYPEID = "#DATE#";
    private static final String BOOLEAN_TYPEID = "#BOOLEAN#";
    private static final String LIST_TYPEID = "#LIST#";

    private NotificationServerUtil() {
    }

    public static String convertNotificationDataToXML(NotificationData data) {
        StringBuilder xml = new StringBuilder();
        if (data != null) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            xml.append("<NOTIFY>");
            xml.append("  <LOGIN>");
            xml.append("    <USER><![CDATA[");
            xml.append(data.getLoginUser());
            xml.append("]]></USER>");
            xml.append("    <PASSWORD><![CDATA[");
            xml.append(data.getLoginPassword());
            xml.append("]]></PASSWORD>");
            xml.append("  </LOGIN>");
            xml.append("  <MESSAGE><![CDATA[");
            xml.append(data.getMessage());
            xml.append("]]></MESSAGE>");
            xml.append("  <SENDER>");
            xml.append("    <ID><![CDATA[");
            xml.append(data.getSenderId());
            xml.append("]]></ID>");
            xml.append("    <NAME><![CDATA[");
            xml.append(data.getSenderName());
            xml.append("]]></NAME>");
            xml.append("    <ANSWERALLOWED>");
            xml.append(data.isAnswerAllowed());
            xml.append("</ANSWERALLOWED>");
            xml.append("  </SENDER>");
            xml.append("  <COMMENT><![CDATA[");
            xml.append(data.getComment());
            xml.append("]]></COMMENT>");
            xml.append("  <TARGET CHANNEL=\"");
            xml.append(data.getTargetChannel());
            xml.append("\">");
            xml.append("    <NAME><![CDATA[");
            xml.append(data.getTargetName());
            xml.append("]]></NAME>");
            xml.append("    <RECEIPT><![CDATA[");
            xml.append(data.getTargetReceipt());
            xml.append("]]></RECEIPT>");
            xml.append("    <PARAM><![CDATA[");
            xml.append(NotificationServerUtil.packKeyValues(data.getTargetParam()));
            xml.append("]]></PARAM>");
            xml.append("  </TARGET>");
            xml.append("  <PRIORITY SPEED=\"");
            xml.append(data.getPrioritySpeed());
            xml.append("\"/>");
            xml.append("  <REPORT>");
            xml.append("  </REPORT>");
            xml.append("</NOTIFY>");
        }
        return xml.toString();
    }

    public static NotificationData convertXMLToNotificationData(String xml) throws NotificationServerException {
        NotificationData data = new NotificationData();
        ByteArrayInputStream input2 = new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8));
        try {
            SAXParser parser = parserFactory.newSAXParser();
            NotifyContentHandler handler = new NotifyContentHandler(data, parser.getXMLReader());
            parser.parse((InputStream)input2, (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new NotificationServerException(e);
        }
        return data;
    }

    public static Map<String, Object> unpackKeyValues(String keyValueString) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        if (keyValueString != null) {
            NotificationServerUtil.parseKeyValueString(keyValueString, result, key, value);
            NotificationServerUtil.decodeValue(result, key, value);
        }
        return result;
    }

    private static void parseKeyValueString(String keyValueString, Map<String, Object> result, StringBuilder key, StringBuilder value) {
        StringBuilder sb = key;
        for (int i = 0; i < keyValueString.length(); ++i) {
            char c = keyValueString.charAt(i);
            if (c == ';') {
                if (i + 1 < keyValueString.length() && keyValueString.charAt(i + 1) == ';') {
                    sb.append(c);
                    ++i;
                    continue;
                }
                NotificationServerUtil.decodeValue(result, key, value);
                key.setLength(0);
                value.setLength(0);
                sb = key;
                continue;
            }
            if (c == '=') {
                if (i + 1 < keyValueString.length() && keyValueString.charAt(i + 1) == '=') {
                    sb.append(c);
                    ++i;
                    continue;
                }
                sb = value;
                continue;
            }
            sb.append(c);
        }
    }

    private static void decodeValue(Map<String, Object> result, StringBuilder key, StringBuilder value) {
        String strValue = value.toString();
        if (strValue.startsWith(DATE_TYPEID)) {
            strValue = strValue.substring(6);
            result.put(key.toString(), new Date(Long.parseLong(strValue)));
        } else if (strValue.startsWith(BOOLEAN_TYPEID)) {
            strValue = strValue.substring(9);
            result.put(key.toString(), Boolean.valueOf(strValue));
        } else if (strValue.startsWith(LIST_TYPEID)) {
            strValue = strValue.substring(6);
            List listValue = Stream.of(strValue.split(",")).collect(Collectors.toList());
            result.put(key.toString(), listValue);
        } else {
            result.put(key.toString(), strValue);
        }
    }

    protected static String doubleSeparators(String theValue) {
        if (theValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(theValue.length() + 5);
        char[] chars = theValue.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '=': {
                    sb.append("==");
                    continue block4;
                }
                case ';': {
                    sb.append(";;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String packKeyValues(Map<String, Object> keyValues) {
        StringBuilder sb = new StringBuilder();
        boolean bNotTheFirst = false;
        if (keyValues != null) {
            Set<String> theKeys = keyValues.keySet();
            for (String theKey : theKeys) {
                if (bNotTheFirst) {
                    sb.append(';');
                }
                bNotTheFirst = NotificationServerUtil.formatInString(theKey, keyValues, sb, bNotTheFirst);
            }
        }
        return sb.toString();
    }

    private static boolean formatInString(String theKey, Map<String, Object> keyValues, StringBuilder sb, boolean bNotTheFirst) {
        Object keyValue = "";
        boolean success = true;
        boolean result = bNotTheFirst;
        try {
            keyValue = (String)keyValues.get(theKey);
        }
        catch (ClassCastException cce) {
            success = false;
        }
        if (!success) {
            try {
                Date date = (Date)keyValues.get(theKey);
                keyValue = DATE_TYPEID + date.getTime();
                success = true;
            }
            catch (ClassCastException date) {
                // empty catch block
            }
        }
        if (!success) {
            try {
                Boolean bool = (Boolean)keyValues.get(theKey);
                keyValue = BOOLEAN_TYPEID + bool;
                success = true;
            }
            catch (ClassCastException bool) {
                // empty catch block
            }
        }
        if (!success) {
            try {
                Collection collection = (Collection)keyValues.get(theKey);
                if (!collection.isEmpty()) {
                    keyValue = LIST_TYPEID + String.join((CharSequence)",", collection);
                    success = true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (success) {
            sb.append(NotificationServerUtil.doubleSeparators(theKey)).append('=').append(NotificationServerUtil.doubleSeparators((String)keyValue));
            result = true;
        }
        return result;
    }

    static {
        parserFactory.setNamespaceAware(false);
        parserFactory.setValidating(false);
    }
}

