/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.NotificationMetaData;

public class CurrentUserNotificationContext {
    public static CurrentUserNotificationContext getCurrentUserNotificationContext() {
        CurrentUserNotificationContext current = (CurrentUserNotificationContext)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)CurrentUserNotificationContext.class.getName(), CurrentUserNotificationContext.class);
        if (current == null) {
            current = new CurrentUserNotificationContext();
            CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)CurrentUserNotificationContext.class.getName(), (Object)current);
        }
        return current;
    }

    public void checkManualUserNotification(NotificationMetaData notificationMetaData) throws NotificationException {
        if (NotificationManagerSettings.isUserManualNotificationRecipientLimitEnabled() && notificationMetaData.isManualUserOne()) {
            boolean limitExceeded;
            int nbUserReceivers = notificationMetaData.getAllUserRecipients().size();
            UserDetail currentUser = UserDetail.getCurrentRequester();
            if (currentUser != null) {
                limitExceeded = currentUser.isUserManualNotificationUserReceiverLimit() && currentUser.getUserManualNotificationUserReceiverLimitValue() < nbUserReceivers;
            } else {
                boolean bl = limitExceeded = NotificationManagerSettings.getUserManualNotificationRecipientLimit() < nbUserReceivers;
            }
            if (limitExceeded) {
                throw new NotificationException("The user receiving limit is exceeded", new String[0]);
            }
        }
    }
}

