/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.ContributionOperationContextPropertyHandler;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Service
public class UserSubscriptionNotificationSendingHandler
implements ContributionOperationContextPropertyHandler {
    private static final String SENDING_NOT_ENABLED_KEY = UserSubscriptionNotificationSendingHandler.class.getName() + "#SENDING_ENABLED";
    private static final String SENDING_NOT_ENABLED_JMS_WAY_KEY = UserSubscriptionNotificationSendingHandler.class.getName() + "#SENDING_ENABLED_JMS_WAY";

    public static UserSubscriptionNotificationSendingHandler get() {
        return (UserSubscriptionNotificationSendingHandler)ServiceProvider.getService(UserSubscriptionNotificationSendingHandler.class, (Annotation[])new Annotation[0]);
    }

    protected UserSubscriptionNotificationSendingHandler() {
    }

    @Override
    public void parseForProperty(HttpServletRequest request) {
        if (NotificationManagerSettings.isSubscriptionNotificationConfirmationEnabled()) {
            String parameter = request.getParameter("SUBSCRIPTION_NOTIFICATION_SENDING_CONFIRMATION");
            String header = request.getHeader("SUBSCRIPTION_NOTIFICATION_SENDING_CONFIRMATION");
            Confirmation confirmation = this.getMergedConfirmations(parameter, header);
            CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)SENDING_NOT_ENABLED_KEY, (Object)confirmation);
        }
    }

    public void skipNotificationSend() {
        this.getOrCreateConfirmation().skip = true;
    }

    public boolean isSubscriptionNotificationEnabledForCurrentRequest() {
        Confirmation confirmation = this.getConfirmation();
        return confirmation.isNotificationSendEnabled();
    }

    @Nullable
    public String getSubscriptionNotificationUserNoteFromCurrentRequest() {
        Confirmation confirmation = this.getConfirmation();
        if (confirmation.isNotificationSendEnabled()) {
            return confirmation.note;
        }
        return null;
    }

    private Confirmation getMergedConfirmations(String parameter, String header) {
        Confirmation fromParameters = this.decodeConfirmation(parameter);
        Confirmation fromHeaders = this.decodeConfirmation(header);
        Confirmation mergedConfirmation = new Confirmation();
        mergedConfirmation.skip = fromParameters.skip || fromHeaders.skip;
        mergedConfirmation.note = StringUtil.defaultStringIfNotDefined((String)fromParameters.note, (String)fromHeaders.note);
        return mergedConfirmation;
    }

    private Confirmation decodeConfirmation(String value) {
        String decodedValue = StringUtil.isDefined((String)value) ? (value.startsWith("{") ? value : new String(StringUtil.fromBase64((String)value))) : "{}";
        return (Confirmation)JSONCodec.decode((String)decodedValue, Confirmation.class);
    }

    private Confirmation getConfirmation() {
        Confirmation confirmation = (Confirmation)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)SENDING_NOT_ENABLED_KEY, Confirmation.class);
        if (confirmation == null) {
            confirmation = (Confirmation)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)SENDING_NOT_ENABLED_JMS_WAY_KEY, Confirmation.class);
        }
        return confirmation == null ? new Confirmation() : confirmation;
    }

    @NonNull
    private Confirmation getOrCreateConfirmation() {
        Confirmation confirmation = (Confirmation)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)SENDING_NOT_ENABLED_KEY, Confirmation.class, () -> new Confirmation());
        return Objects.requireNonNull(confirmation);
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Confirmation
    implements Serializable {
        private static final long serialVersionUID = 3590333285305219765L;
        @XmlElement
        private boolean skip = false;
        @XmlElement
        private String note = null;

        private Confirmation() {
        }

        boolean isNotificationSendEnabled() {
            return !this.skip;
        }
    }
}

