/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Link;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public class SimpleUserNotification
implements UserNotification {
    private User sender = null;
    private static final NotifAction NOTIF_ACTION = NotifAction.REPORT;
    private String componentInstanceId = null;
    private UnaryOperator<String> title = l -> "";
    private UnaryOperator<String> message = l -> "";
    private String extraMessage = null;
    private Pair<String, String> templatePath = Pair.of((Object)"notification/user", (Object)"simple");
    private BiConsumer<SilverpeasTemplate, String> templateConsumer = null;
    private Function<String, Link> link = null;
    private String emailLanguage = null;
    private final Set<String> userIds = new HashSet<String>();
    private final Set<String> groupIds = new HashSet<String>();
    private final Set<String> externalMails = new HashSet<String>();

    private SimpleUserNotification() {
    }

    public static SimpleUserNotification fromSystem() {
        return SimpleUserNotification.from(null);
    }

    public static SimpleUserNotification from(User sender) {
        SimpleUserNotification userNotification = new SimpleUserNotification();
        userNotification.sender = sender;
        return userNotification;
    }

    public SimpleUserNotification andComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
        return this;
    }

    public SimpleUserNotification withTitle(UnaryOperator<String> title) {
        this.title = title;
        return this;
    }

    public SimpleUserNotification andMessage(UnaryOperator<String> message) {
        this.message = message;
        return this;
    }

    public SimpleUserNotification withExtraMessage(String extraMessage) {
        this.extraMessage = extraMessage;
        return this;
    }

    public SimpleUserNotification fillTemplate(Pair<String, String> path, BiConsumer<SilverpeasTemplate, String> template) {
        this.templatePath = path;
        this.templateConsumer = template;
        return this;
    }

    public SimpleUserNotification withLink(Function<String, Link> link) {
        this.link = link;
        return this;
    }

    public SimpleUserNotification toUsers(Collection<User> users) {
        return this.toUsers(users.stream());
    }

    public SimpleUserNotification toUsers(User ... users) {
        return this.toUsers(Arrays.stream(users));
    }

    public SimpleUserNotification toUsers(Stream<User> users) {
        users.forEach(u -> this.userIds.add(u.getId()));
        return this;
    }

    public SimpleUserNotification toGroups(Collection<Group> groups) {
        return this.toGroups(groups.stream());
    }

    public SimpleUserNotification toGroups(Group ... groups) {
        return this.toGroups(Arrays.stream(groups));
    }

    public SimpleUserNotification toGroups(Stream<Group> groups) {
        groups.forEach(g -> this.groupIds.add(g.getId()));
        return this;
    }

    public SimpleUserNotification toEMails(Stream<String> eMails, String language) {
        this.emailLanguage = DisplayI18NHelper.verifyLanguage((String)language);
        eMails.forEach(this.externalMails::add);
        return this;
    }

    public NotificationMetaData getNotificationMetaData() {
        return this.build().getNotificationMetaData();
    }

    public void send() {
        this.build().send();
    }

    public void send(BuiltInNotifAddress notificationAddress) {
        this.build().send(notificationAddress);
    }

    private UserNotification build() {
        return new SimpleUserNotificationBuilder(this).build();
    }

    private static class SimpleUserNotificationBuilder
    extends AbstractTemplateUserNotificationBuilder<Object>
    implements FallbackToCoreTemplatePathBehavior {
        private static final Object NO_RESOURCE = new Object();
        private final SimpleUserNotification source;

        private SimpleUserNotificationBuilder(SimpleUserNotification source) {
            super(NO_RESOURCE);
            this.source = source;
        }

        @Override
        protected void perform(Object resource) {
            super.perform(resource);
            if (StringUtil.isDefined((String)this.source.emailLanguage)) {
                super.getNotificationMetaData().setExternalLanguage(this.source.emailLanguage);
            }
        }

        @Override
        protected void performTemplateData(String language, Object resource, SilverpeasTemplate template) {
            String title = (String)this.source.title.apply(language);
            String message = (String)this.source.message.apply(language);
            String senderName = this.source.sender != null ? this.source.sender.getDisplayedName() : "";
            super.getNotificationMetaData().addLanguage(language, title, "");
            template.setAttribute("message", (Object)Encode.forHtml((String)message));
            template.setAttribute("sender", (Object)senderName);
            if (this.source.link != null) {
                super.getNotificationMetaData().setLink(this.source.link.apply(language), language);
            }
            if (this.source.templateConsumer != null) {
                this.source.templateConsumer.accept(template, language);
            }
            if (StringUtil.isDefined((String)this.source.extraMessage)) {
                super.getNotificationMetaData().addExtraMessage(this.source.extraMessage, language);
            }
        }

        @Override
        protected void performNotificationResource(String language, Object resource, NotificationResourceData notificationResourceData) {
        }

        @Override
        protected String getTitle(String language) {
            return (String)this.source.title.apply(language);
        }

        @Override
        protected String getTemplateFileName() {
            return (String)this.source.templatePath.getSecond();
        }

        @Override
        protected String getBundleSubjectKey() {
            return null;
        }

        @Override
        protected String getTemplatePath() {
            return (String)this.source.templatePath.getFirst();
        }

        @Override
        protected NotifAction getAction() {
            return NOTIF_ACTION;
        }

        @Override
        protected String getComponentInstanceId() {
            return StringUtil.isDefined((String)this.source.componentInstanceId) ? this.source.componentInstanceId : null;
        }

        @Override
        protected String getSender() {
            return this.source.sender != null ? this.source.sender.getId() : "";
        }

        @Override
        protected Collection<String> getUserIdsToNotify() {
            return this.source.userIds;
        }

        @Override
        protected Collection<String> getGroupIdsToNotify() {
            return this.source.groupIds;
        }

        @Override
        protected Collection<String> getExternalAddressesToNotify() {
            return this.source.externalMails;
        }

        @Override
        protected boolean isSendImmediately() {
            return true;
        }
    }
}

