/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.service;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.node.dao.NodeDAO;
import org.silverpeas.core.node.dao.NodeI18NDAO;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodeRuntimeException;
import org.silverpeas.core.node.notification.NodeEventNotifier;
import org.silverpeas.core.node.service.AnonymousMethodOnNode;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.util.ServiceProvider;

@Service
public class NodeDeletion {
    @Inject
    private NodeDAO nodeDAO;

    public void deleteNodes(NodePK pk, Connection inConnection, AnonymousMethodOnNode afterDeletion) {
        try {
            Collection<NodeDetail> children = this.nodeDAO.getChildrenDetails(inConnection, pk);
            for (NodeDetail childNode : children) {
                this.deleteNodes(childNode.getNodePK(), inConnection, afterDeletion);
            }
            this.deleteNode(pk, inConnection);
            if (afterDeletion != null) {
                afterDeletion.invoke(pk);
            }
        }
        catch (Exception ex) {
            throw new NodeRuntimeException(ex);
        }
    }

    private void deleteNode(NodePK pk, Connection connection) throws SQLException {
        NodeDetail node = this.nodeDAO.loadRow(connection, pk);
        this.nodeDAO.deleteRow(connection, pk);
        NodeI18NDAO.removeTranslations(connection, Integer.parseInt(pk.getId()));
        IndexEntryKey indexEntry = new IndexEntryKey(pk.getComponentName(), "Node", pk.getId());
        IndexEngineProxy.removeIndexEntry(indexEntry);
        NodeEventNotifier notifier = (NodeEventNotifier)((Object)ServiceProvider.getService(NodeEventNotifier.class, (Annotation[])new Annotation[0]));
        notifier.notifyEventOn(ResourceEvent.Type.DELETION, new NodeDetail[]{node});
    }
}

