/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.node.model.NodeI18NDetail;
import org.silverpeas.core.node.model.NodeI18NPK;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.kernel.util.StringUtil;

public class NodeI18NDAO {
    private static final String TABLENAME = "sb_node_nodeI18N";
    private static final String FIELDS = "id, nodeId, lang, nodeName, nodeDescription";
    private static final String SELECT_TRANSLATIONS = "SELECT id, nodeId, lang, nodeName, nodeDescription FROM sb_node_nodeI18N WHERE nodeId = ?";
    private static final String REMOVE_TRANSLATION = "DELETE FROM sb_node_nodeI18N WHERE id = ?";
    private static final String REMOVE_TRANSLATIONS = "DELETE FROM sb_node_nodeI18N WHERE nodeId = ?";
    private static final String INSERT_TRANSLATION = "INSERT INTO sb_node_nodeI18N VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_TRANSLATION = "UPDATE sb_node_nodeI18N SET lang = ?, nodeName =  ?, nodeDescription = ?  WHERE id = ?";

    private NodeI18NDAO() {
    }

    public static void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)TABLENAME).where("nodeId in (" + JdbcSqlQuery.select((String)"nodeId from sb_node_node").where("instanceId = ?", new Object[0]).getSqlQuery() + ")", new Object[]{componentInstanceId}).execute();
    }

    private static NodeI18NDetail resultSet2NodeDetail(ResultSet rs) throws SQLException {
        int id = rs.getInt(1);
        int nodeId = rs.getInt(2);
        String lang = rs.getString(3);
        String name = rs.getString(4);
        String description = StringUtil.defaultStringIfNotDefined((String)rs.getString(5));
        NodeI18NDetail i18n = new NodeI18NDetail(String.valueOf(id), lang, name, description);
        i18n.setObjectId(Integer.toString(nodeId));
        return i18n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeI18NPK saveTranslation(Connection con, NodeI18NDetail nd) throws SQLException {
        NodeI18NPK pk = new NodeI18NPK("useless");
        int newId = DBUtil.getNextId((String)nd.getTableName(), (String)"id");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(INSERT_TRANSLATION);
            prepStmt.setInt(1, newId);
            prepStmt.setInt(2, Integer.parseInt(nd.getNodeId()));
            prepStmt.setString(3, nd.getLanguage());
            prepStmt.setString(4, nd.getName());
            prepStmt.setString(5, nd.getDescription());
            prepStmt.executeUpdate();
            pk.setId(String.valueOf(newId));
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeI18NPK updateTranslation(Connection con, NodeI18NDetail nd) throws SQLException {
        NodeI18NPK pk = new NodeI18NPK(String.valueOf(nd.getId()));
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(UPDATE_TRANSLATION);
            prepStmt.setString(1, nd.getLanguage());
            prepStmt.setString(2, nd.getName());
            prepStmt.setString(3, nd.getDescription());
            prepStmt.setInt(4, Integer.parseInt(nd.getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return pk;
    }

    public static void removeTranslation(Connection con, String id) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(REMOVE_TRANSLATION);
            prepStmt.setInt(1, Integer.parseInt(id));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void removeTranslations(Connection con, int nodeId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(REMOVE_TRANSLATIONS);
            prepStmt.setInt(1, nodeId);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static List<NodeI18NDetail> getTranslations(Connection con, String nodeId) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(SELECT_TRANSLATIONS);){
            ArrayList<NodeI18NDetail> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(nodeId));
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<NodeI18NDetail> result = new ArrayList<NodeI18NDetail>();
                    while (rs.next()) {
                        result.add(NodeI18NDAO.resultSet2NodeDetail(rs));
                    }
                    arrayList = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    static Map<Integer, List<NodeI18NDetail>> getIndexedTranslations(Connection con, List<String> nodeIds) throws SQLException {
        List localIds = nodeIds.stream().map(Integer::parseInt).collect(Collectors.toList());
        return JdbcSqlQuery.executeBySplittingOn(localIds, (idBatch, result) -> JdbcSqlQuery.select((String)FIELDS).from(new String[]{TABLENAME}).where("nodeId", new Object[0]).in(idBatch).executeWith(con, r -> {
            NodeI18NDetail node = NodeI18NDAO.resultSet2NodeDetail((ResultSet)r);
            MapUtil.putAddList(result, Integer.parseInt(node.getNodeId()), node);
            return null;
        }));
    }
}

