/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.LookupTranslator;
import org.silverpeas.core.mail.MailException;
import org.silverpeas.core.mail.extractor.ExtractorException;
import org.silverpeas.core.mail.extractor.Mail;
import org.silverpeas.core.mail.extractor.MailAttachment;
import org.silverpeas.core.mail.extractor.MailExtractor;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class EMLExtractor
implements MailExtractor {
    private static final CharSequenceTranslator ESCAPE_ISO8859_1 = new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE);
    private MimeMessage message;

    public EMLExtractor(File file) throws ExtractorException {
        try (FileInputStream in = new FileInputStream(file);){
            this.init(in);
        }
        catch (Exception e) {
            throw new ExtractorException(e);
        }
    }

    public EMLExtractor(InputStream file) throws ExtractorException {
        try {
            this.init(file);
        }
        catch (MessagingException e) {
            throw new ExtractorException(e);
        }
    }

    private void init(InputStream file) throws MessagingException {
        Properties props = System.getProperties();
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        mailSession.setDebug(true);
        this.message = new MimeMessage(mailSession, file);
    }

    @Override
    public Mail getMail() throws MailException {
        try {
            Mail mail = new Mail();
            mail.setDate(this.message.getSentDate());
            mail.setSubject(this.message.getSubject());
            String body2 = null;
            Object messageContent = this.message.getContent();
            if (messageContent instanceof Multipart) {
                body2 = this.getBody((Multipart)messageContent);
            } else if (messageContent instanceof String) {
                body2 = (String)messageContent;
            }
            if (this.message.getFrom() != null) {
                mail.setFrom((InternetAddress)this.message.getFrom()[0]);
            }
            mail.setTo(this.message.getRecipients(Message.RecipientType.TO));
            mail.setCc(this.message.getRecipients(Message.RecipientType.CC));
            mail.setBody(ESCAPE_ISO8859_1.translate((CharSequence)body2));
            return mail;
        }
        catch (IOException | MessagingException e) {
            throw new MailException(e);
        }
    }

    @Override
    public List<MailAttachment> getAttachments() throws MailException {
        try {
            ArrayList<MailAttachment> attachments = new ArrayList<MailAttachment>();
            Object messageContent = this.message.getContent();
            if (messageContent instanceof Multipart) {
                this.processMultipart((Multipart)messageContent, attachments);
            }
            return attachments;
        }
        catch (IOException | MessagingException e) {
            throw new MailException(e);
        }
    }

    private String getBody(Multipart multipart) throws MessagingException, IOException {
        int partsNumber = multipart.getCount();
        String body2 = "";
        for (int i = 0; i < partsNumber; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (part.isMimeType("text/html")) {
                return (String)part.getContent();
            }
            if (part.isMimeType("text/plain")) {
                body2 = WebEncodeHelper.javaStringToHtmlParagraphe((String)((String)part.getContent()));
                continue;
            }
            if (!(part.getContent() instanceof Multipart)) continue;
            return this.getBody((Multipart)part.getContent());
        }
        return body2;
    }

    private String processMultipart(Multipart multipart, List<MailAttachment> attachments) throws MessagingException, IOException {
        int partsNumber = multipart.getCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < partsNumber; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            sb.append(this.processMailPart((Part)part, attachments));
        }
        return sb.toString();
    }

    private String processMailPart(Part part, List<MailAttachment> attachments) throws MessagingException, IOException {
        if (!this.isTextPart(part)) {
            Object content = part.getContent();
            if (content instanceof Multipart) {
                Multipart mContent = (Multipart)content;
                return this.processMultipart(mContent, attachments);
            }
            if (attachments != null) {
                this.processMailAttachmentPart(part, attachments);
            }
        } else {
            if (part.getContentType().contains("text/html")) {
                return (String)part.getContent();
            }
            if (part.getContentType().contains("text/plain")) {
                return WebEncodeHelper.javaStringToHtmlParagraphe((String)((String)part.getContent()));
            }
        }
        return "";
    }

    private void processMailAttachmentPart(Part part, List<MailAttachment> attachments) throws MessagingException, IOException {
        String contentID = this.getContentID(part);
        String fileName = this.getFileName(part);
        if (fileName == null && contentID != null) {
            fileName = contentID.replaceAll("[<>]", "");
        }
        if (fileName != null) {
            MailAttachment attachment = new MailAttachment(fileName);
            String dir = FileRepositoryManager.getTemporaryPath() + "mail" + System.currentTimeMillis();
            File file = new File(dir, fileName);
            FileUtils.copyInputStreamToFile((InputStream)part.getInputStream(), (File)file);
            if (StringUtil.isNotDefined((String)FilenameUtils.getExtension((String)fileName))) {
                String fileExtension = new ContentType(FileUtil.getMimeType(file.getAbsolutePath())).getSubType();
                String fileNameWithExtension = fileName + "." + fileExtension;
                File fileWithExtension = new File(dir, fileNameWithExtension);
                Files.move(file.toPath(), fileWithExtension.toPath(), new CopyOption[0]);
                file = fileWithExtension;
                attachment.setName(fileNameWithExtension);
            }
            attachment.setPath(file.getAbsolutePath());
            attachment.setSize(file.length());
            attachment.setContentID(contentID);
            attachments.add(attachment);
        }
    }

    private boolean isTextPart(Part part) throws MessagingException {
        String disposition = part.getDisposition();
        if (!"attachment".equals(disposition) && !"inline".equals(disposition)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                return "text".equalsIgnoreCase(type.getPrimaryType());
            }
            catch (ParseException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        } else if ("inline".equals(disposition)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                return "text".equalsIgnoreCase(type.getPrimaryType()) && this.getFileName(part) == null;
            }
            catch (ParseException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return false;
    }

    private String getFileName(Part part) throws MessagingException {
        String fileName = part.getFileName();
        if (!StringUtil.isDefined((String)fileName)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                fileName = type.getParameter("name");
            }
            catch (ParseException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        if (StringUtil.isDefined((String)fileName) && fileName.startsWith("=?") && fileName.endsWith("?=")) {
            try {
                fileName = MimeUtility.decodeText((String)part.getFileName());
            }
            catch (UnsupportedEncodingException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return fileName;
    }

    private String getContentID(Part part) throws MessagingException {
        return Optional.ofNullable(part.getHeader("Content-ID")).stream().flatMap(Stream::of).findFirst().orElse(null);
    }
}

