/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail;

import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.silverpeas.core.util.MailSettings;
import org.silverpeas.kernel.util.StringUtil;

public class MailAddress {
    private String email = "";
    private String name = "";

    public static MailAddress eMail(String email) {
        MailAddress mailAddress = new MailAddress();
        if (StringUtil.isDefined((String)email)) {
            mailAddress.email = email;
        }
        return mailAddress;
    }

    private MailAddress() {
    }

    public MailAddress withName(String name) {
        this.name = StringUtil.defaultStringIfNotDefined((String)name);
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public InternetAddress getAuthorizedInternetAddress() throws UnsupportedEncodingException, AddressException {
        return MailSettings.getAuthorizedEmailAddress(this.getEmail(), this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailAddress that = (MailAddress)o;
        return this.email.equals(that.email) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.email.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

