/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContent;
import org.silverpeas.core.contribution.indicator.NewContributionIndicator;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.i18n.AbstractBean;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.SearchResultTranslation;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class SearchResult
extends AbstractBean {
    private String keywords;
    private final LocalDate creationDate;
    private final String creatorId;
    private final LocalDate lastUpdateDate;
    private String lastUpdaterId;
    private final ContributionIdentifier cId;
    private String linkedResId;
    private float score;
    private String serverName;
    private String thumbnailURL;
    private String attachmentFilename;
    private boolean externalResult = false;
    private boolean alias = false;
    private Map<String, String> sortableXMLFormFields = null;
    private Map<String, String> formFieldsForFacets;

    private SearchResult(MatchingIndexEntry mie) {
        this.setName(mie.getTitle());
        this.setDescription(mie.getPreview());
        this.keywords = mie.getKeywords(null);
        this.creationDate = this.getLocalDate(mie.getCreationDate());
        this.lastUpdateDate = this.getLocalDate(mie.getLastModificationDate());
        this.creatorId = mie.getCreationUser();
        this.lastUpdaterId = mie.getLastModificationUser();
        this.cId = ContributionIdentifier.from((String)mie.getComponent(), (String)mie.getObjectId(), (String)mie.getObjectType());
        this.linkedResId = mie.getLinkedObjectId();
        this.score = mie.getScore();
        this.serverName = mie.getServerName();
        this.attachmentFilename = mie.getFilename();
        this.externalResult = mie.isExternalResult();
        this.alias = mie.isAlias();
        this.sortableXMLFormFields = mie.getSortableXMLFormFields();
        this.formFieldsForFacets = mie.getXMLFormFieldsForFacets();
        Iterator<String> languages = mie.getLanguages();
        while (languages.hasNext()) {
            String language = languages.next();
            SearchResultTranslation translation = new SearchResultTranslation(language, mie.getTitle(language), mie.getPreview(language));
            this.addTranslation(translation);
        }
        if (mie.getThumbnail() != null) {
            this.thumbnailURL = mie.getThumbnail().startsWith("/") ? mie.getThumbnail() : FileServerUtils.getUrl(mie.getComponent(), mie.getThumbnail(), mie.getThumbnailMimeType(), mie.getThumbnailDirectory());
        }
    }

    private SearchResult(GlobalSilverContent gsc) {
        this.setName(gsc.getName());
        this.setDescription(gsc.getDescription());
        this.creationDate = DateUtil.toLocalDate((Date)gsc.getCreationDate());
        this.creatorId = gsc.getUserId();
        this.lastUpdateDate = DateUtil.toLocalDate((Date)gsc.getLastUpdateDate());
        this.cId = ContributionIdentifier.from((String)gsc.getInstanceId(), (String)gsc.getId(), (String)gsc.getType());
        for (String language : gsc.getTranslations().keySet()) {
            SearchResultTranslation translation = new SearchResultTranslation(language, gsc.getName(language), gsc.getDescription(language));
            this.addTranslation(translation);
        }
        this.thumbnailURL = gsc.getThumbnailURL();
    }

    public static SearchResult fromIndexEntry(MatchingIndexEntry mie) {
        return new SearchResult(mie);
    }

    public static SearchResult fromGlobalSilverContent(GlobalSilverContent gsc) {
        return new SearchResult(gsc);
    }

    public boolean isLinkedToAnotherContribution() {
        return StringUtil.isDefined((String)this.linkedResId);
    }

    private LocalDate getLocalDate(String date) {
        if (StringUtil.isDefined((String)date)) {
            try {
                if (date.contains("/")) {
                    return DateUtil.toLocalDate((String)date);
                }
                return DateUtil.parseFromLucene((String)date);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return null;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public LocalDate getCreationLocalDate() {
        return this.creationDate;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public LocalDate getLastUpdateLocalDate() {
        return this.lastUpdateDate;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public String getId() {
        return this.cId.getLocalId();
    }

    public String getInstanceId() {
        return this.cId.getComponentInstanceId();
    }

    public String getType() {
        return this.cId.getType();
    }

    public String getLinkedResourceId() {
        return this.linkedResId;
    }

    public float getScore() {
        return this.score;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public void setThumbnailURL(String url) {
        this.thumbnailURL = url;
    }

    public String getAttachmentFilename() {
        return this.attachmentFilename;
    }

    public Map<String, String> getSortableXMLFormFields() {
        return this.sortableXMLFormFields;
    }

    public Map<String, String> getFormFieldsForFacets() {
        return this.formFieldsForFacets;
    }

    public boolean isExternalResult() {
        return this.externalResult;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public boolean isNew() {
        return Optional.ofNullable(this.lastUpdateDate != null ? this.lastUpdateDate : this.creationDate).map(d -> d.atStartOfDay(ZoneId.systemDefault()).toInstant()).map(i -> NewContributionIndicator.isNewContribution((ContributionIdentifier)this.cId, (Instant)i)).orElse(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return Objects.equals(this.cId, that.cId);
    }

    public int hashCode() {
        return Objects.hash(this.cId);
    }
}

