/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.kernel.util.StringUtil;

public class DidYouMeanIndexer {
    private static final String SUFFIX_SPELLING_INDEX_PATH = "Spell";
    private static final String DEFAULT_LANGUAGE = "fr";

    private DidYouMeanIndexer() {
    }

    public static void createSpellIndex(String field, String originalIndexDirectory, String spellIndexDirectory) {
        if (!(StringUtil.isDefined((String)field) && StringUtil.isDefined((String)originalIndexDirectory) && StringUtil.isDefined((String)spellIndexDirectory))) {
            IndexingLogger.indexingLogger().error("Invalid argument passed to create a spell index", new Object[0]);
            return;
        }
    }

    public static void createSpellIndex(String field, String originalIndexDirectory) {
        DidYouMeanIndexer.createSpellIndex(field, originalIndexDirectory, originalIndexDirectory + SUFFIX_SPELLING_INDEX_PATH);
    }

    public static boolean clearSpellIndex(String pathSpellChecker) {
        boolean isCleared = false;
        File file = new File(pathSpellChecker);
        if (file.exists()) {
            try (SpellChecker spell = new SpellChecker((Directory)FSDirectory.open((Path)file.toPath()));){
                spell.clearIndex();
                isCleared = true;
            }
            catch (IOException e) {
                IndexingLogger.indexingLogger().error((Throwable)e);
            }
        }
        return isCleared;
    }

    public static void clearSpellIndex(String[] paths) {
        for (String path : paths) {
            DidYouMeanIndexer.clearSpellIndex(path);
        }
    }

    public static void createSpellIndexForAllLanguage(String field, String originalIndexDirectory) {
        StringBuilder localizedField = new StringBuilder(field);
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            if (!language.equalsIgnoreCase(DEFAULT_LANGUAGE)) {
                localizedField.append("_").append(language);
            }
            DidYouMeanIndexer.createSpellIndex(localizedField.toString(), originalIndexDirectory, originalIndexDirectory + SUFFIX_SPELLING_INDEX_PATH);
        }
    }
}

