/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.util;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.ActionType;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.subscription.SubscriptionResource;

public class ContributionBatchManagementContext {
    private final List<ContributionContext> contributionContexts = new ArrayList<ContributionContext>();
    private ActionType entityPersistenceAction = ActionType.READ;

    public static ContributionBatchManagementContext initialize() {
        return new ContributionBatchManagementContext();
    }

    private ContributionBatchManagementContext() {
    }

    public ContributionBatchManagementContext addContributionContext(Contribution contribution, ContributionStatus contributionStatus, Location location, SubscriptionResource linkedSubscriptionResource) {
        this.contributionContexts.add(new ContributionContext(contribution, contributionStatus, location, linkedSubscriptionResource));
        return this;
    }

    public List<ContributionContext> getContributionContexts() {
        return this.contributionContexts;
    }

    public ContributionBatchManagementContext forPersistenceAction(ActionType entityPersistenceAction) {
        this.entityPersistenceAction = entityPersistenceAction;
        return this;
    }

    public ActionType getEntityPersistenceAction() {
        return this.entityPersistenceAction;
    }

    public static class ContributionContext {
        private final Contribution contribution;
        private final ContributionStatus contributionStatus;
        private final Location location;
        private final SubscriptionResource linkedSubscriptionResource;

        private ContributionContext(Contribution contribution, ContributionStatus contributionStatus, Location location, SubscriptionResource linkedSubscriptionResource) {
            this.contribution = contribution;
            this.contributionStatus = contributionStatus;
            this.location = location;
            this.linkedSubscriptionResource = linkedSubscriptionResource;
        }

        public Contribution getContribution() {
            return this.contribution;
        }

        public ContributionStatus getContributionStatus() {
            return this.contributionStatus;
        }

        public Location getLocation() {
            return this.location;
        }

        public SubscriptionResource getLinkedSubscriptionResource() {
            return this.linkedSubscriptionResource;
        }
    }
}

