/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.template.publication;

import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.GlobalContext;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.FormEncryptionContentIterator;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSet;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.content.form.record.IdentifiedRecordTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateImpl;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.security.encryption.ContentEncryptionServiceProvider;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;
import org.silverpeas.kernel.util.SystemWrapper;

@Service
@Singleton
public class PublicationTemplateManager
implements ComponentInstanceDeletion {
    private final Map<String, PublicationTemplate> externalTemplates = new HashMap<String, PublicationTemplate>();
    private final Map<String, PublicationTemplateImpl> templates = new HashMap<String, PublicationTemplateImpl>();
    private String templateDir;
    private String defaultTemplateDir;
    private JAXBContext jaxbContext = null;

    @PostConstruct
    private void setup() {
        SettingBundle templateSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.publicationTemplate.settings.template");
        this.templateDir = templateSettings.getString("templateDir");
        this.defaultTemplateDir = SystemWrapper.getInstance().getenv("SILVERPEAS_HOME") + "/data/templateRepository/";
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PublicationTemplateImpl.class});
        }
        catch (JAXBException e) {
            SilverLogger.getLogger((Object)this).error("can not initialize JAXB_CONTEXT", (Throwable)e);
        }
    }

    public static PublicationTemplateManager getInstance() {
        return (PublicationTemplateManager)ServiceProvider.getService(PublicationTemplateManager.class, (Annotation[])new Annotation[0]);
    }

    public String makePath(String fileName) {
        if (!StringUtil.isDefined((String)this.templateDir)) {
            return fileName;
        }
        if (!StringUtil.isDefined((String)fileName)) {
            return this.templateDir;
        }
        return Paths.get(this.templateDir, fileName).toString().replace('\\', '/');
    }

    private String makeDefaultPath(String fileName) {
        if (!StringUtil.isDefined((String)this.defaultTemplateDir)) {
            return fileName;
        }
        if (!StringUtil.isDefined((String)fileName)) {
            return this.defaultTemplateDir;
        }
        return Paths.get(this.defaultTemplateDir, fileName).toString().replace('\\', '/');
    }

    public String getTemplateDirectoryPath() {
        return this.templateDir;
    }

    public GenericRecordSet addDynamicPublicationTemplate(String externalId, String templateFileName) throws PublicationTemplateException {
        Object fileName = templateFileName;
        try {
            if (!((String)fileName).endsWith(".xml")) {
                fileName = (String)fileName + ".xml";
            }
            PublicationTemplate thePubTemplate = this.loadPublicationTemplate((String)fileName);
            RecordTemplate recordTemplate = thePubTemplate.getRecordTemplate();
            return PublicationTemplateManager.getGenericRecordSetManager().createRecordSet(externalId, recordTemplate, (String)fileName, thePubTemplate.isDataEncrypted());
        }
        catch (FormException e) {
            throw new PublicationTemplateException("Fail to add dynamic publication template " + templateFileName + " for " + externalId, (Throwable)((Object)e));
        }
    }

    public PublicationTemplate getPublicationTemplate(String externalId) throws PublicationTemplateException {
        return this.getPublicationTemplate(externalId, null);
    }

    public PublicationTemplate getPublicationTemplate(String externalId, String templateFileName) throws PublicationTemplateException {
        String currentTemplateFileName = templateFileName;
        PublicationTemplate thePubTemplate = this.externalTemplates.get(externalId);
        if (thePubTemplate == null) {
            if (templateFileName == null) {
                try {
                    RecordSet set = PublicationTemplateManager.getGenericRecordSetManager().getRecordSet(externalId);
                    RecordTemplate template = set.getRecordTemplate();
                    if (!(template instanceof IdentifiedRecordTemplate)) {
                        throw new PublicationTemplateException("Unexpected type of data record template: " + template.getClass().getSimpleName(), new String[0]);
                    }
                    currentTemplateFileName = ((IdentifiedRecordTemplate)template).getTemplateName();
                }
                catch (Exception e) {
                    throw new PublicationTemplateException("Fail to get publication template for " + externalId, e);
                }
            }
            thePubTemplate = this.loadPublicationTemplate(currentTemplateFileName);
            thePubTemplate.setExternalId(externalId);
            this.externalTemplates.put(externalId, thePubTemplate);
        }
        return thePubTemplate;
    }

    public void removePublicationTemplate(String externalId) throws PublicationTemplateException {
        try {
            PublicationTemplateManager.getGenericRecordSetManager().removeRecordSet(externalId);
        }
        catch (FormException e) {
            throw new PublicationTemplateException("Fail to remove publication template for " + externalId, (Throwable)((Object)e));
        }
    }

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try {
            List<String> externalIds = PublicationTemplateManager.getGenericRecordSetManager().getExternalIdOfComponentInstanceId(componentInstanceId);
            for (String externalId : externalIds) {
                this.removePublicationTemplate(externalId);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("error during deletion of data of component instance identifier " + componentInstanceId, (Throwable)e);
        }
    }

    public PublicationTemplate loadPublicationTemplate(String xmlFileName) throws PublicationTemplateException {
        try {
            PublicationTemplateImpl publicationTemplate = this.templates.get(xmlFileName);
            if (publicationTemplate != null) {
                return publicationTemplate.basicClone();
            }
            String xmlFilePath = this.makePath(xmlFileName);
            File xmlFile = new File(xmlFilePath);
            if (!xmlFile.exists()) {
                xmlFilePath = this.makeDefaultPath(xmlFileName);
                xmlFile = new File(xmlFilePath);
            }
            if (!xmlFile.exists()) {
                return null;
            }
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            publicationTemplate = (PublicationTemplateImpl)unmarshaller.unmarshal(xmlFile);
            publicationTemplate.setFileName(xmlFileName);
            this.templates.put(xmlFileName, publicationTemplate);
            return publicationTemplate.basicClone();
        }
        catch (JAXBException e) {
            throw new PublicationTemplateException("Fail to load publication template " + xmlFileName, e);
        }
    }

    public void savePublicationTemplate(PublicationTemplate template) throws PublicationTemplateException, CryptoException {
        boolean encryptionChanged;
        String xmlFileName = template.getFileName();
        PublicationTemplate previousTemplate = this.loadPublicationTemplate(xmlFileName);
        boolean bl = encryptionChanged = previousTemplate != null && template.isDataEncrypted() != previousTemplate.isDataEncrypted();
        if (encryptionChanged) {
            if (template.isDataEncrypted()) {
                PublicationTemplateManager.getGenericRecordSetManager().encryptData(xmlFileName);
            } else {
                PublicationTemplateManager.getGenericRecordSetManager().decryptData(xmlFileName);
            }
        }
        try {
            String xmlFilePath = this.makePath(xmlFileName);
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)template, new File(xmlFilePath));
        }
        catch (JAXBException e) {
            throw new PublicationTemplateException("Fail to save publication template " + xmlFileName, e);
        }
    }

    public List<PublicationTemplate> getPublicationTemplates(boolean onlyVisible) throws PublicationTemplateException {
        Collection<File> templateNames;
        ArrayList<PublicationTemplate> publicationTemplates = new ArrayList<PublicationTemplate>();
        try {
            templateNames = FileFolderManager.getAllFile(this.templateDir);
        }
        catch (UtilException e1) {
            throw new PublicationTemplateException("Fail to get publication templates", e1);
        }
        for (File templateFile : templateNames) {
            String fileName = templateFile.getName();
            try {
                String extension = FileRepositoryManager.getFileExtension(fileName);
                if (!"xml".equalsIgnoreCase(extension)) continue;
                PublicationTemplate template = this.loadPublicationTemplate(fileName.substring(fileName.lastIndexOf(File.separator) + 1));
                if (onlyVisible) {
                    if (!template.isVisible()) continue;
                    publicationTemplates.add(template);
                    continue;
                }
                publicationTemplates.add(template);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return publicationTemplates;
    }

    public List<PublicationTemplate> getPublicationTemplates() throws PublicationTemplateException {
        return this.getPublicationTemplates(true);
    }

    public List<PublicationTemplate> getPublicationTemplates(@Nullable GlobalContext globalContext) throws PublicationTemplateException {
        List<PublicationTemplate> theTemplates = this.getPublicationTemplates(true);
        if (globalContext == null) {
            return theTemplates;
        }
        ArrayList<PublicationTemplate> allowedTemplates = new ArrayList<PublicationTemplate>();
        for (PublicationTemplate template : theTemplates) {
            if (!this.isPublicationTemplateVisible(template, globalContext)) continue;
            allowedTemplates.add(template);
        }
        return allowedTemplates;
    }

    public List<PublicationTemplate> getDirectoryTemplates() {
        ArrayList<PublicationTemplate> directoryTemplates = new ArrayList<PublicationTemplate>();
        try {
            List<PublicationTemplate> theTemplates = this.getPublicationTemplates(true);
            for (PublicationTemplate template : theTemplates) {
                if (!template.isDirectoryUsage()) continue;
                directoryTemplates.add(template);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return directoryTemplates;
    }

    public boolean isPublicationTemplateVisible(String templateName, GlobalContext globalContext) throws PublicationTemplateException {
        PublicationTemplate template = this.loadPublicationTemplate(templateName);
        return this.isPublicationTemplateVisible(template, globalContext);
    }

    private boolean isPublicationTemplateVisible(PublicationTemplate template, GlobalContext globalContext) {
        if (template.isDirectoryUsage()) {
            return false;
        }
        if (!template.isRestrictedVisibility()) {
            return true;
        }
        if (template.isRestrictedVisibilityToInstance()) {
            return this.isTemplateVisibleAccordingToInstance(template, globalContext);
        }
        return this.isAllowed(template, globalContext);
    }

    private boolean isAllowed(PublicationTemplate template, GlobalContext globalContext) {
        boolean allowed;
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        boolean bl = allowed = !template.isRestrictedVisibilityToApplication() || this.isTemplateVisibleAccordingToApplication(template, globalContext, oc);
        if (allowed) {
            if (!template.isRestrictedVisibilityToSpace()) {
                return true;
            }
            return this.isTemplateVisibleAccordingToSpace(template, globalContext, oc);
        }
        return false;
    }

    private boolean isTemplateVisibleAccordingToInstance(PublicationTemplate template, GlobalContext context) {
        List<String> restrictedInstanceIds = template.getInstances();
        return restrictedInstanceIds.contains(context.getComponentId());
    }

    private boolean isTemplateVisibleAccordingToApplication(PublicationTemplate template, GlobalContext context, OrganizationController oc) {
        List<String> restrictedApplications = template.getApplications();
        String componentName = context.getComponentName();
        if (StringUtil.isDefined((String)context.getComponentId())) {
            ComponentInstLight component = oc.getComponentInstLight(context.getComponentId());
            componentName = component.getName();
        }
        return restrictedApplications.contains(componentName);
    }

    private boolean isTemplateVisibleAccordingToSpace(PublicationTemplate template, GlobalContext context, OrganizationController oc) {
        List<String> restrictedToSpaceIds = template.getSpaces();
        List<SpaceInstLight> spacePath = oc.getPathToSpace(context.getSpaceId());
        for (SpaceInstLight space : spacePath) {
            String spaceId = space.getId();
            if (!restrictedToSpaceIds.contains(spaceId)) continue;
            return true;
        }
        return false;
    }

    public List<PublicationTemplate> getSearchablePublicationTemplates() throws PublicationTemplateException {
        ArrayList<PublicationTemplate> searchableTemplates = new ArrayList<PublicationTemplate>();
        List<PublicationTemplate> publicationTemplates = this.getPublicationTemplates();
        for (PublicationTemplate template : publicationTemplates) {
            try {
                if (template.getSearchForm() == null) continue;
                searchableTemplates.add(template);
            }
            catch (PublicationTemplateException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)((Object)e));
            }
        }
        return searchableTemplates;
    }

    public List<PublicationTemplate> getEncryptedPublicationTemplates() throws PublicationTemplateException {
        ArrayList<PublicationTemplate> encryptedTemplates = new ArrayList<PublicationTemplate>();
        List<PublicationTemplate> publicationTemplates = this.getPublicationTemplates();
        for (PublicationTemplate template : publicationTemplates) {
            if (!template.isDataEncrypted()) continue;
            encryptedTemplates.add(template);
        }
        return encryptedTemplates;
    }

    public void removePublicationTemplateFromCaches(String fileName) {
        ArrayList<String> externalIdsToRemove = new ArrayList<String>();
        Collection<PublicationTemplate> publicationTemplates = this.externalTemplates.values();
        for (PublicationTemplate template : publicationTemplates) {
            if (!template.getFileName().equals(fileName)) continue;
            externalIdsToRemove.add(template.getExternalId());
        }
        for (String externalId : externalIdsToRemove) {
            this.externalTemplates.remove(externalId);
        }
        this.templates.remove(fileName);
        PublicationTemplateManager.getGenericRecordSetManager().removeTemplateFromCache(fileName);
    }

    private static GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    protected void registerForRenewingContentCipher() {
        FormEncryptionContentIterator contentIterator = new FormEncryptionContentIterator();
        ContentEncryptionServiceProvider.getContentEncryptionService().registerForContentCiphering(contentIterator);
    }

    public void saveData(String xmlFormName, PagesContext context, List<FileItem> items) throws SilverpeasException {
        if (context == null) {
            throw new SilverpeasException("Context must be defined !", new String[0]);
        }
        if (StringUtil.isNotDefined((String)context.getComponentId()) || StringUtil.isNotDefined((String)context.getObjectId()) || StringUtil.isNotDefined((String)context.getLanguage()) || StringUtil.isNotDefined((String)context.getUserId())) {
            throw new SilverpeasException("Context is not complete ! ComponentId, ObjectId, Language and UserId must be defined...", new String[0]);
        }
        String ignoreThisForm = FileUploadUtil.getParameter(items, "ignoreThisForm");
        if (StringUtil.isDefined((String)xmlFormName) && !StringUtil.getBooleanValue((String)ignoreThisForm)) {
            PublicationTemplate pub = this.getTemplateAndRegisterIt(xmlFormName, context);
            try {
                RecordSet set = pub.getRecordSet();
                Form form = pub.getUpdateForm();
                DataRecord data = set.getRecord(context.getObjectId());
                if (data == null) {
                    data = set.getEmptyRecord();
                    data.setId(context.getObjectId());
                }
                form.update(items, data, context);
                set.save(data);
            }
            catch (Exception e) {
                throw new SilverpeasException("Unable to save data", (Throwable)e);
            }
        }
    }

    private PublicationTemplate getTemplateAndRegisterIt(String xmlFormName, PagesContext context) throws SilverpeasException {
        PublicationTemplate pub;
        String shortName = this.getShortName(xmlFormName);
        String externalId = context.getComponentId() + ":" + shortName;
        try {
            pub = this.getPublicationTemplate(externalId);
            if (pub == null) {
                SilverLogger.getLogger((Object)this).warn("This template is not yet registered", new Object[0]);
                pub = this.registerTemplate(externalId, shortName);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn("This template is not yet registered. Error: " + e.getMessage(), new Object[0]);
            pub = this.registerTemplate(externalId, shortName);
        }
        return pub;
    }

    private PublicationTemplate registerTemplate(String externalId, String shortName) throws SilverpeasException {
        PublicationTemplate pub;
        try {
            this.addDynamicPublicationTemplate(externalId, shortName);
            pub = this.getPublicationTemplate(externalId);
        }
        catch (Exception templateException) {
            throw new SilverpeasException("Unable to register template", (Throwable)templateException);
        }
        return pub;
    }

    public Form getFormAndData(String xmlFormName, PagesContext context, boolean readOnly) throws SilverpeasException {
        if (StringUtil.isNotDefined((String)xmlFormName)) {
            return null;
        }
        PublicationTemplate pub = this.getTemplateAndRegisterIt(xmlFormName, context);
        try {
            DataRecord data;
            RecordSet set = pub.getRecordSet();
            Form form = pub.getUpdateForm();
            if (readOnly) {
                form = pub.getViewForm();
            }
            if ((data = set.getRecord(context.getObjectId())) == null) {
                if (readOnly) {
                    return null;
                }
                data = set.getEmptyRecord();
                data.setId(context.getObjectId());
            }
            form.setData(data);
            return form;
        }
        catch (Exception e) {
            throw new SilverpeasException("Unable to get data", (Throwable)e);
        }
    }

    public void setDataIntoIndex(String xmlFormName, String componentId, String userId, FullIndexEntry indexEntry) {
        try {
            String shortName = this.getShortName(xmlFormName);
            PublicationTemplate usedTemplate = this.getPublicationTemplate(componentId + ":" + shortName);
            RecordSet set = usedTemplate.getRecordSet();
            set.indexRecord(userId, shortName, indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public PublicationTemplate getDirectoryTemplate() {
        List<PublicationTemplate> directoryTemplates = this.getDirectoryTemplates();
        if (CollectionUtil.isNotEmpty(directoryTemplates)) {
            PublicationTemplate template = directoryTemplates.get(0);
            this.setExternalId(template);
            return template;
        }
        return null;
    }

    public PublicationTemplate getDirectoryTemplate(PagesContext context) {
        String domainId = context.getDomainId();
        String userId = context.getObjectId();
        if (StringUtil.isDefined((String)userId)) {
            domainId = User.getById((String)userId).getDomainId();
        }
        List<PublicationTemplate> directoryTemplates = this.getDirectoryTemplates();
        for (PublicationTemplate template : directoryTemplates) {
            if ((!StringUtil.isDefined((String)userId) || !template.isVisibleToUser(userId)) && (!StringUtil.isNotDefined((String)userId) || !template.isVisibleToDomain(domainId))) continue;
            this.setExternalId(template);
            return template;
        }
        return null;
    }

    private void setExternalId(PublicationTemplate template) {
        String shortName = this.getShortName(template.getFileName());
        String externalId = "users:" + shortName;
        template.setExternalId(externalId);
    }

    public Form getDirectoryForm(PagesContext context, boolean viewMode) {
        PublicationTemplate template = this.getDirectoryTemplate(context);
        if (template != null) {
            try {
                return this.getFormAndData(template.getFileName(), context, viewMode);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return null;
    }

    public void deleteDirectoryData(String userId) {
        PublicationTemplate template = this.getDirectoryTemplate();
        if (template != null) {
            try {
                template.getRecordSet().delete(userId);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    private String getShortName(String name) {
        String shortName = name;
        if (shortName.contains(".")) {
            shortName = name.substring(name.indexOf("/") + 1, name.indexOf("."));
        }
        return shortName;
    }

    public Map<String, String> getDirectoryFormValues(String userId, String domainId, String language) {
        PagesContext pageContext = this.getFormContext(userId, domainId, language);
        PublicationTemplate template = this.getDirectoryTemplate(pageContext);
        if (template != null) {
            try {
                DataRecord data = template.getRecordSet().getRecord(userId);
                if (data != null) {
                    return data.getValues(language);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectoryFormLabels(String userId, String domainId, String language) {
        HashMap<String, String> labels = new HashMap<String, String>();
        PagesContext pageContext = this.getFormContext(userId, domainId, language);
        PublicationTemplate template = this.getDirectoryTemplate(pageContext);
        if (template != null) {
            try {
                FieldTemplate[] fields;
                for (FieldTemplate field : fields = template.getRecordTemplate().getFieldTemplates()) {
                    labels.put(field.getFieldName(), field.getLabel(language));
                }
                return labels;
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    private PagesContext getFormContext(String userId, String domainId, String language) {
        PagesContext pageContext = new PagesContext();
        pageContext.setDomainId(domainId);
        pageContext.setObjectId(userId);
        pageContext.setLanguage(language);
        return pageContext;
    }

    public Map<String, Integer> getNumberOfRecordsByTemplateAndComponents(String templateName) throws FormException {
        return PublicationTemplateManager.getGenericRecordSetManager().getNumberOfRecordsByTemplateAndComponents(templateName);
    }
}

