/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.template.form.service;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.template.form.service.FormTemplateRuntimeException;
import org.silverpeas.core.contribution.template.form.service.FormTemplateService;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateImpl;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.exception.UtilException;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultFormTemplateService
implements FormTemplateService {
    @Override
    public DataRecord getRecord(String externalId, String id) {
        PublicationTemplate pub = this.getPublicationTemplate(externalId);
        return this.getRecord(id, pub, null);
    }

    @Override
    public PublicationTemplate getPublicationTemplate(String externalId) {
        try {
            return PublicationTemplateManager.getInstance().getPublicationTemplate(externalId);
        }
        catch (Exception e) {
            throw new FormTemplateRuntimeException("DefaultFormTemplateService.getPublicationTemplate", 4, "Getting template '" + externalId + "' failed !", e);
        }
    }

    @Override
    public List<XMLField> getXMLFieldsForExport(String externalId, String id) {
        return this.getXMLFieldsForExport(externalId, id, null);
    }

    @Override
    public List<XMLField> getXMLFieldsForExport(String externalId, String id, String language) {
        PublicationTemplateImpl template = (PublicationTemplateImpl)this.getPublicationTemplate(externalId);
        DataRecord data = this.getRecord(id, template, language);
        ArrayList<XMLField> fields = new ArrayList<XMLField>();
        if (data != null) {
            try {
                String[] fieldNames = template.getRecordTemplate().getFieldNames();
                for (int f = 0; fieldNames != null && f < fieldNames.length; ++f) {
                    String fieldName = fieldNames[f];
                    FieldTemplate fieldTemplate = template.getRecordTemplate().getFieldTemplate(fieldName);
                    if (fieldTemplate == null) continue;
                    if (!fieldTemplate.isRepeatable()) {
                        Field field = data.getField(fieldName);
                        XMLField xmlField = this.getXMLField(field, fieldTemplate);
                        if (xmlField == null) continue;
                        fields.add(xmlField);
                        continue;
                    }
                    List<XMLField> xmlFields = this.getRepeatableXMLField(data, fieldTemplate);
                    fields.addAll(xmlFields);
                }
            }
            catch (Exception e) {
                throw new FormTemplateRuntimeException("DefaultFormTemplateService.getXMLFields", 4, "Getting fields for externalId = " + externalId + " and id = " + id + " failed !", e);
            }
        }
        return fields;
    }

    private XMLField getXMLField(Field field, FieldTemplate fieldTemplate) {
        XMLField xmlField = null;
        if (field != null) {
            Object fieldValue = field.getStringValue();
            if (field.getTypeName().equals("file")) {
                fieldValue = "image".equals(fieldTemplate.getDisplayerName()) ? "image_" + (String)fieldValue : "file_" + (String)fieldValue;
            }
            xmlField = new XMLField(field.getName(), (String)fieldValue);
        }
        return xmlField;
    }

    private List<XMLField> getRepeatableXMLField(DataRecord dataRecord, FieldTemplate fieldTemplate) {
        int maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
        ArrayList<XMLField> xmlFields = new ArrayList<XMLField>();
        for (int occ = 0; occ < maxOccurrences; ++occ) {
            Field fieldOcc = dataRecord.getField(fieldTemplate.getFieldName(), occ);
            if (fieldOcc == null || fieldOcc.isNull()) continue;
            xmlFields.add(this.getXMLField(fieldOcc, fieldTemplate));
        }
        return xmlFields;
    }

    @Override
    public String getWysiwygContent(String componentId, String objectId, String fieldName, String language) {
        try {
            return WysiwygFCKFieldDisplayer.getContentFromFile(componentId, objectId, fieldName, language);
        }
        catch (UtilException e) {
            throw new FormTemplateRuntimeException("DefaultFormTemplateService.getWysiwygContent", 4, "Getting Wysiwyg content for componentId = " + componentId + " and id = " + objectId + " failed !", (Exception)((Object)e));
        }
    }

    private DataRecord getRecord(String id, PublicationTemplate pub, String language) {
        try {
            RecordSet set = pub.getRecordSet();
            return set.getRecord(id, language);
        }
        catch (Exception e) {
            throw new FormTemplateRuntimeException("DefaultFormTemplateService.getRecord", 4, "Getting record for id '" + id + " failed !", e);
        }
    }
}

