/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.rating.service;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.RaterRatingPK;
import org.silverpeas.core.contribution.rating.model.Rating;
import org.silverpeas.core.contribution.rating.service.RatingRepository;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;

@Transactional
@Singleton
@Service
public class DefaultRatingService
implements RatingService,
ComponentInstanceDeletion {
    @Inject
    private RatingRepository repository;

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try {
            RatingService.get().deleteComponentRatings(componentInstanceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateRating(RaterRatingPK pk, int note) {
        Rating rating = this.repository.getRating(pk);
        if (rating == null) {
            rating = new Rating();
            rating.setAuthorId(pk.getRater().getId());
            rating.setContributionId(pk.getContributionId());
            rating.setContributionType(pk.getContributionType());
            rating.setInstanceId(pk.getInstanceId());
        }
        rating.setNote(note);
        this.repository.save((IdentifiableEntity)rating);
    }

    @Override
    public void moveRating(ContributionRatingPK pk, String componentInstanceId) {
        this.repository.moveAllRatingsOfAContribution(pk, componentInstanceId);
    }

    @Override
    public void deleteRating(ContributionRatingPK pk) {
        this.repository.deleteAllRatingsOfAContribution(pk);
    }

    @Override
    public void deleteRaterRating(RaterRatingPK pk) {
        Rating rating = this.repository.getRating(pk);
        if (rating != null) {
            this.repository.delete((IdentifiableEntity[])new Rating[]{rating});
        }
    }

    @Override
    public void deleteComponentRatings(String componentInstanceId) {
        this.repository.deleteAllRatingsInComponentInstance(componentInstanceId);
    }

    @Override
    public Map<String, ContributionRating> getRatings(SilverpeasContent ... contributions) {
        HashMap<String, ContributionRating> indexedContributionRatings = new HashMap<String, ContributionRating>(contributions.length);
        for (SilverpeasContent contribution : contributions) {
            indexedContributionRatings.put(contribution.getId(), this.getRating(contribution));
        }
        return indexedContributionRatings;
    }

    @Override
    public ContributionRating getRating(SilverpeasContent contribution) {
        return this.getRating(new ContributionRatingPK(contribution.getId(), contribution.getComponentInstanceId(), contribution.getContributionType()));
    }

    @Override
    public ContributionRating getRating(ContributionRatingPK pk) {
        return this.getRatingIndexedByContributionIds(pk.getInstanceId(), pk.getContributionType(), pk.getContributionId()).values().iterator().next();
    }

    private Map<String, ContributionRating> getRatingIndexedByContributionIds(String componentInstanceId, String contributionType, String ... contributionIds) {
        Map<String, ContributionRating> ratingsByContribution = this.repository.getAllRatingByContributions(componentInstanceId, contributionType, contributionIds);
        for (String contributionId : contributionIds) {
            if (ratingsByContribution.containsKey(contributionId)) continue;
            ContributionRating contributionRating = new ContributionRating(new ContributionRatingPK(contributionId, componentInstanceId, contributionType));
            ratingsByContribution.put(contributionId, contributionRating);
        }
        return ratingsByContribution;
    }

    @Override
    public boolean hasUserRating(RaterRatingPK pk) {
        return this.repository.getRating(pk) != null;
    }
}

