/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.model;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.owasp.encoder.Encode;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.ContributionModificationContextHandler;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.ContributionWithVisibility;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.indicator.NewContributionIndicator;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.contribution.model.WithAttachment;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WithThumbnail;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetailModel;
import org.silverpeas.core.contribution.publication.model.PublicationI18N;
import org.silverpeas.core.contribution.publication.model.PublicationIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationPath;
import org.silverpeas.core.contribution.publication.model.PublicationRuntimeException;
import org.silverpeas.core.contribution.publication.model.Visibility;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.Rateable;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.contribution.template.form.service.FormTemplateService;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.contribution.tracking.ModificationTracked;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.i18n.I18n;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.reminder.WithReminder;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.xml.DateAdapter;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement(namespace="http://www.silverpeas.org/exchange")
@XmlAccessorType(value=XmlAccessType.NONE)
@ModificationTracked
public class PublicationDetail
extends AbstractI18NBean<PublicationI18N>
implements I18nContribution,
ContributionWithVisibility,
SilverContentInterface,
Rateable,
Serializable,
WithAttachment,
WithThumbnail,
WithReminder,
WithPermanentLink {
    private static final long serialVersionUID = 9199848912262605680L;
    private static final String EXCHANGE_NAMESPACE = "http://www.silverpeas.org/exchange";
    public static final String DELAYED_VISIBILITY_AT_MODEL_PROPERTY = "DELAYED_VISIBILITY_AT";
    private PublicationPK pk;
    private String infoId;
    @XmlElement(name="creationDate", namespace="http://www.silverpeas.org/exchange")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date creationDate;
    @XmlElement(name="beginDate", namespace="http://www.silverpeas.org/exchange")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date beginDate;
    @XmlElement(name="endDate", namespace="http://www.silverpeas.org/exchange")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date endDate;
    @XmlElement(name="creatorId", namespace="http://www.silverpeas.org/exchange")
    private String creatorId;
    @XmlElement(name="creatorName", namespace="http://www.silverpeas.org/exchange")
    private String creatorName;
    @XmlElement(name="importance", namespace="http://www.silverpeas.org/exchange")
    private int importance;
    @XmlElement(name="version", namespace="http://www.silverpeas.org/exchange")
    private String version;
    @XmlElement(name="keywords", namespace="http://www.silverpeas.org/exchange")
    private String keywords;
    private String content;
    @XmlElement(name="status", namespace="http://www.silverpeas.org/exchange")
    private String status;
    private Date updateDate;
    private String updaterId;
    private Date removalDate;
    private String removerId;
    private Date validateDate;
    private String validatorId;
    private String beginHour;
    private String endHour;
    private String author;
    private String targetValidatorId;
    private String cloneId;
    private String cloneStatus;
    private String silverObjectId;
    private String iconUrl;
    private int explicitRank = -1;
    private List<XMLField> xmlFields = null;
    private int indexOperation = 0;
    private boolean statusMustBeChecked = true;
    private boolean updateDateMustBeSet = true;
    private int nbAccess = 0;
    private Visibility visibility = null;
    public static final String DRAFT_STATUS = "Draft";
    public static final String VALID_STATUS = "Valid";
    public static final String TO_VALIDATE_STATUS = "ToValidate";
    public static final String REFUSED_STATUS = "Unvalidate";
    public static final String CLONE_STATUS = "Clone";
    public static final String TYPE = "Publication";
    private boolean alias = false;
    private Location authorizedLocation = null;
    private transient ThumbnailDetail thumbnail = null;
    private ContributionRating contributionRating;

    public static Builder builder() {
        return new Builder(I18n.get().getDefaultLanguage());
    }

    public static Builder builder(String language) {
        return new Builder(language);
    }

    @Override
    protected Class<PublicationI18N> getTranslationType() {
        return PublicationI18N.class;
    }

    protected PublicationDetail() {
    }

    public PublicationPK getPK() {
        return this.pk;
    }

    public void setPk(PublicationPK pk) {
        this.pk = pk;
    }

    public String getInfoId() {
        return this.infoId;
    }

    public void setInfoId(String infoId) {
        this.infoId = infoId;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getRemovalDate() {
        return this.removalDate;
    }

    private void setRemovalDate(Date removalDate) {
        this.removalDate = removalDate;
    }

    public void setRemovalStatus(Date removalDate, String removerId) {
        this.setRemovalDate(removalDate);
        this.setRemoverId(removerId);
    }

    public String getRemoverId() {
        return this.removerId;
    }

    private void setRemoverId(String removerId) {
        this.removerId = removerId;
    }

    public void setVisibilityPeriod(Period period) {
        if (period == null || period.startsAtMinDate()) {
            this.setBeginDate(null);
            this.setBeginHour(null);
        } else {
            Date periodStart = TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)period.getStartDate()).atZoneSameInstant(ZoneId.systemDefault()));
            this.setBeginDate(periodStart);
            this.setBeginHour(DateUtil.formatTime((Date)periodStart));
        }
        if (period == null || period.endsAtMaxDate()) {
            this.setEndDate(null);
            this.setEndHour(null);
        } else {
            Date periodEnd = TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)period.getEndDate()).atZoneSameInstant(ZoneId.systemDefault()));
            this.setEndDate(periodEnd);
            this.setEndHour(DateUtil.formatTime((Date)periodEnd));
        }
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setContentPagePath(String content) {
        this.content = content;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public ContributionIdentifier getIdentifier() {
        return new PublicationIdentifier(this.getInstanceId(), this.getId(), this.getContributionType());
    }

    public int getImportance() {
        return this.importance;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getKeywords(String lang) {
        if (!I18NHelper.isI18nContentActivated) {
            return this.getKeywords();
        }
        PublicationI18N p = (PublicationI18N)this.getTranslations().get(lang);
        if (p == null) {
            p = (PublicationI18N)this.getNextTranslation();
        }
        if (p != null) {
            return p.getKeywords();
        }
        return this.getKeywords();
    }

    public String getContentPagePath() {
        return this.content;
    }

    public String getStatus() {
        return this.status;
    }

    public ContributionStatus getContributionStatus() {
        ContributionStatus contributionStatus = DRAFT_STATUS.equalsIgnoreCase(this.status) ? ContributionStatus.DRAFT : (VALID_STATUS.equalsIgnoreCase(this.status) ? ContributionStatus.VALIDATED : (TO_VALIDATE_STATUS.equalsIgnoreCase(this.status) ? ContributionStatus.PENDING_VALIDATION : (REFUSED_STATUS.equalsIgnoreCase(this.status) ? ContributionStatus.REFUSED : ContributionStatus.UNKNOWN)));
        return contributionStatus;
    }

    public String getImage() {
        Thumbnail thumbDetail = this.getThumbnail();
        if (thumbDetail != null) {
            return thumbDetail.getImageFileName();
        }
        return null;
    }

    public String getImageMimeType() {
        Thumbnail thumbDetail = this.getThumbnail();
        if (thumbDetail != null) {
            return thumbDetail.getMimeType();
        }
        return null;
    }

    public Thumbnail getThumbnail() {
        if (this.thumbnail == null && this.getPK() != null && this.getPK().getInstanceId() != null && this.getPK().getId() != null) {
            ThumbnailDetail thumbnailReference = new ThumbnailDetail(this.getPK().getInstanceId(), Integer.parseInt(this.getPK().getId()), 1);
            this.thumbnail = ThumbnailController.getCompleteThumbnail(thumbnailReference);
        }
        return this.thumbnail;
    }

    public Optional<PublicationPath> getResourcePath() {
        return Optional.of(this).map(PublicationPath::getPath);
    }

    public void setThumbnail(ThumbnailDetail thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    @Override
    public User getLastUpdater() {
        return this.updaterId != null ? User.getById((String)this.updaterId) : null;
    }

    public String getAuthor() {
        return this.author;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("PublicationDetail {").append("\n");
        if (this.getPK() != null) {
            result.append(" getPK().getId() = ").append(this.getPK().getId()).append("\n");
            result.append(" getPK().getEd() = ").append(this.getPK().getSpace()).append("\n");
            result.append(" getPK().getCo() = ").append(this.getPK().getComponentName()).append("\n");
        }
        result.append(" getName() = ").append(this.getName()).append("\n");
        result.append(" getDescription() = ").append(this.getDescription()).append("\n");
        result.append(" getCreationDate() = ").append(this.getCreationDate()).append("\n");
        result.append(" getBeginDate() = ").append(this.getBeginDate()).append("\n");
        result.append(" getBeginHour() = ").append(this.getBeginHour()).append("\n");
        result.append(" getEndDate() = ").append(this.getEndDate()).append("\n");
        result.append(" getEndHour() = ").append(this.getEndHour()).append("\n");
        result.append(" getCreatorId() = ").append(this.getCreatorId()).append("\n");
        result.append(" getImportance() = ").append(this.getImportance()).append("\n");
        result.append(" getVersion() = ").append(this.getVersion()).append("\n");
        result.append(" getKeywords() = ").append(this.getKeywords()).append("\n");
        result.append(" getContent() = ").append(this.getContentPagePath()).append("\n");
        result.append(" getStatus() = ").append(this.getStatus()).append("\n");
        result.append(" getUpdateDate() = ").append(this.getLastUpdateDate()).append("\n");
        result.append(" getUpdaterId() = ").append(this.getUpdaterId()).append("\n");
        result.append(" getValidateDate() = ").append(this.getValidateDate()).append("\n");
        result.append(" getValidatorId() = ").append(this.getValidatorId()).append("\n");
        result.append(" getSilverObjectId() = ").append(this.getSilverObjectId()).append("\n");
        result.append(" getAuthor() = ").append(this.getAuthor()).append("\n");
        result.append("}");
        return result.toString();
    }

    public Date getValidateDate() {
        return this.validateDate;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidateDate(Date validateDate) {
        this.validateDate = validateDate;
    }

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    public void setBeginHour(String hour) {
        this.beginHour = hour;
    }

    public String getBeginHour() {
        return this.beginHour;
    }

    public void setEndHour(String hour) {
        this.endHour = hour;
    }

    public String getEndHour() {
        return this.endHour;
    }

    public void setSilverObjectId(String silverObjectId) {
        this.silverObjectId = silverObjectId;
    }

    public void setSilverObjectId(int silverObjectId) {
        this.silverObjectId = Integer.toString(silverObjectId);
    }

    public String getSilverObjectId() {
        if (this.silverObjectId == null) {
            ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
            try {
                int objectId = contentMgtEngine.getSilverContentId(this.getId(), this.getInstanceId());
                if (objectId >= 0) {
                    this.silverObjectId = String.valueOf(objectId);
                }
            }
            catch (ContentManagerException ex) {
                this.silverObjectId = null;
            }
        }
        return this.silverObjectId;
    }

    @Override
    public String getURL() {
        return "searchResult?Type=Publication&Id=" + this.getId();
    }

    @Override
    public String getId() {
        return this.getPK().getId();
    }

    @Override
    public String getInstanceId() {
        return this.getPK().getComponentName();
    }

    @Override
    public String getDate() {
        if (this.getLastUpdateDate() != null) {
            return DateUtil.date2SQLDate((Date)this.getLastUpdateDate());
        }
        return DateUtil.date2SQLDate((Date)this.getCreationDate());
    }

    @Override
    public String getSilverCreationDate() {
        return DateUtil.date2SQLDate((Date)this.getCreationDate());
    }

    public String getTitle() {
        return this.getName();
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @Override
    public String getIconUrl() {
        return this.iconUrl;
    }

    public List<XMLField> getXmlFields() {
        return this.getXmlFields(null);
    }

    public List<XMLField> getXmlFields(String language) {
        if ("0".equals(this.getInfoId())) {
            return new ArrayList<XMLField>();
        }
        if (this.xmlFields == null) {
            try {
                this.xmlFields = this.getFormTemplateBm().getXMLFieldsForExport(this.getPK().getInstanceId() + ":" + this.getInfoId(), this.getPK().getId(), language);
            }
            catch (Exception e) {
                throw new PublicationRuntimeException(e);
            }
        }
        return this.xmlFields;
    }

    public Map<String, String> getFormValues(String language) {
        HashMap<String, String> formValues = new HashMap<String, String>();
        if ("0".equals(this.getInfoId())) {
            return formValues;
        }
        DataRecord data = null;
        PublicationTemplate pub = null;
        try {
            pub = PublicationTemplateManager.getInstance().getPublicationTemplate(this.getPK().getInstanceId() + ":" + this.getInfoId());
            data = pub.getRecordSet().getRecord(this.pk.getId());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn(SilverpeasExceptionMessages.failureOnGetting((String)"form record with", (Object)MessageFormat.format("pubid {0} and infoId {1}", this.getPK().getId(), this.getInfoId())), new Object[]{e});
        }
        if (data == null) {
            return formValues;
        }
        String[] fieldNames = data.getFieldNames();
        PagesContext pageContext = new PagesContext();
        pageContext.setLanguage(language);
        for (String fieldName : fieldNames) {
            try {
                Field field = data.getField(fieldName);
                GenericFieldTemplate fieldTemplate = (GenericFieldTemplate)pub.getRecordTemplate().getFieldTemplate(fieldName);
                FieldDisplayer<Field> fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "simpletext");
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                fieldDisplayer.display(out, field, fieldTemplate, pageContext);
                formValues.put(fieldName, sw.toString());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn(SilverpeasExceptionMessages.failureOnGetting((String)"field value with", (Object)MessageFormat.format("pubid {0} and fieldName {1}", this.getPK().getId(), fieldName)), new Object[]{e});
            }
        }
        return formValues;
    }

    public String getFieldValue(String fieldNameAndLanguage) {
        String[] params = fieldNameAndLanguage.split(",");
        String fieldName = params[0];
        String language = null;
        if (params.length > 1) {
            language = params[1];
        }
        String fieldValue = "";
        List<XMLField> xmlFieldsForLanguage = this.getXmlFields(language);
        for (XMLField xmlField : xmlFieldsForLanguage) {
            if (!fieldName.equals(xmlField.getName())) continue;
            fieldValue = this.getValueOfField(xmlField, language);
        }
        return fieldValue;
    }

    private String getValueOfField(XMLField xmlField, String language) {
        String fieldValue = xmlField.getValue();
        if (fieldValue == null) {
            fieldValue = "";
        } else if (fieldValue.startsWith("image_") || fieldValue.startsWith("file_")) {
            String attachmentId = fieldValue.substring(fieldValue.indexOf(95) + 1);
            fieldValue = this.getFieldValueFromAttachment(attachmentId, language, fieldValue);
        } else {
            fieldValue = fieldValue.startsWith("xmlWysiwygField_") ? WysiwygFCKFieldDisplayer.getContentFromFile(this.getPK().getInstanceId(), this.getPK().getId(), xmlField.getName(), language) : Encode.forHtml((String)fieldValue);
        }
        return fieldValue;
    }

    private String getFieldValueFromAttachment(String attachmentId, String language, String defaultValue) {
        SimpleDocument attachment;
        String fieldValue = StringUtil.isDefined((String)attachmentId) ? (attachmentId.startsWith("/") ? attachmentId : ((attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId, this.getPK().getInstanceId()), language)) != null ? attachment.getAttachmentURL() : defaultValue)) : "";
        return fieldValue;
    }

    private FormTemplateService getFormTemplateBm() {
        try {
            return (FormTemplateService)ServiceProvider.getService(FormTemplateService.class, (Annotation[])new Annotation[0]);
        }
        catch (Exception e) {
            throw new PublicationRuntimeException(e);
        }
    }

    public WysiwygContent getContent() {
        try {
            return WysiwygController.get(this.getPK().getComponentName(), this.getPK().getId(), this.getLanguage());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn("can not load wysiwyg of publication {0} into {1} language", new Object[]{this.getId(), this.getLanguage(), e});
            return new WysiwygContent(LocalizedContribution.from((Contribution)this, (String)this.getLanguage()), "Erreur lors du chargement du wysiwyg !");
        }
    }

    public void setImportance(int importance) {
        this.importance = importance;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
        String lang = this.getLanguage();
        PublicationI18N translation = (PublicationI18N)this.getTranslation(lang);
        translation.setKeywords(keywords);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public int getIndexOperation() {
        return this.indexOperation;
    }

    public void setIndexOperation(int i) {
        this.indexOperation = i;
    }

    public boolean isStatusMustBeChecked() {
        return this.statusMustBeChecked;
    }

    public void setStatusMustBeChecked(boolean statusMustBeChecked) {
        this.statusMustBeChecked = statusMustBeChecked;
    }

    public String getTargetValidatorId() {
        return this.targetValidatorId;
    }

    public void setTargetValidatorId(String targetValidatorId) {
        this.targetValidatorId = targetValidatorId;
    }

    public String[] getTargetValidatorIds() {
        return StringUtil.split((String)this.getTargetValidatorId(), (char)',');
    }

    public String getCloneId() {
        return this.cloneId;
    }

    public void setCloneId(String tempPubId) {
        this.cloneId = tempPubId;
    }

    public boolean haveGotClone() {
        return this.cloneId != null && !"-1".equals(this.cloneId) && !"null".equals(this.cloneId) && !this.cloneId.isEmpty();
    }

    public boolean isClone() {
        return CLONE_STATUS.equalsIgnoreCase(this.getStatus()) || StringUtil.isDefined((String)this.getCloneId()) && !"-1".equals(this.getCloneId()) && !StringUtil.isDefined((String)this.getCloneStatus());
    }

    public boolean isValid() {
        return VALID_STATUS.equalsIgnoreCase(this.getStatus());
    }

    public boolean isValidationRequired() {
        return TO_VALIDATE_STATUS.equalsIgnoreCase(this.getStatus());
    }

    public boolean isRefused() {
        return REFUSED_STATUS.equalsIgnoreCase(this.getStatus());
    }

    public boolean isDraft() {
        return DRAFT_STATUS.equalsIgnoreCase(this.getStatus());
    }

    public boolean isRemoved() {
        return this.removalDate != null;
    }

    public PublicationPK getClonePK() {
        return new PublicationPK(this.getCloneId(), this.getPK());
    }

    public PublicationDetail copy() {
        PublicationDetail clone = new PublicationDetail();
        clone.setLanguage(this.getLanguage());
        clone.setAuthor(this.author);
        clone.setBeginDate(this.beginDate);
        clone.setBeginHour(this.beginHour);
        clone.setContentPagePath(this.content);
        clone.setCreationDate(this.creationDate);
        clone.setCreatorId(this.creatorId);
        clone.setDescription(this.getDescription());
        clone.setEndDate(this.endDate);
        clone.setEndHour(this.endHour);
        clone.setImportance(this.importance);
        clone.setInfoId(this.infoId);
        clone.setKeywords(this.keywords);
        clone.setName(this.getName());
        clone.setPk(new PublicationPK(this.pk.getId(), this.pk));
        clone.setStatus(this.status);
        clone.setTargetValidatorId(this.targetValidatorId);
        clone.setCloneId(this.cloneId);
        clone.setUpdateDate(this.updateDate);
        clone.setUpdaterId(this.updaterId);
        clone.setValidateDate(this.validateDate);
        clone.setValidatorId(this.validatorId);
        clone.setVersion(this.version);
        clone.alias = this.alias;
        clone.authorizedLocation = this.authorizedLocation;
        return clone;
    }

    public String getCloneStatus() {
        return this.cloneStatus;
    }

    public void setCloneStatus(String cloneStatus) {
        this.cloneStatus = cloneStatus;
    }

    public boolean isUpdateDataMustBeSet() {
        return ContributionModificationContextHandler.get().isMinorModification().orElse(false) == false && this.updateDateMustBeSet;
    }

    public void setUpdateDataMustBeSet(boolean updateDataMustBeSet) {
        this.updateDateMustBeSet = updateDataMustBeSet;
    }

    public int getNbAccess() {
        return this.nbAccess;
    }

    public void setNbAccess(int nbAccess) {
        this.nbAccess = nbAccess;
    }

    public boolean isVisible() {
        return this.getVisibility().isVisible();
    }

    public boolean isNoMoreVisible() {
        return this.getVisibility().isNoMoreVisible();
    }

    public boolean isNotYetVisible() {
        return this.getVisibility().isNotYetVisible();
    }

    public Date getBeginDateAndHour() {
        return this.getVisibility().getBeginDateAndHour();
    }

    public Date getEndDateAndHour() {
        return this.getVisibility().getEndDateAndHour();
    }

    @Override
    public Visibility getVisibility() {
        if (this.visibility == null) {
            this.visibility = Visibility.from(this, this.beginDate, this.beginHour, this.endDate, this.endHour);
        }
        return this.visibility;
    }

    public boolean isIndexable() {
        return VALID_STATUS.equals(this.status);
    }

    public boolean isPublicationEditor(String userId) {
        return Objects.equals(this.creatorId, userId) || Objects.equals(this.updaterId, userId);
    }

    public boolean equals(Object o) {
        if (o instanceof PublicationDetail) {
            PublicationDetail anotherPublication = (PublicationDetail)o;
            return this.pk.equals(anotherPublication.getPK());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        return hash;
    }

    public String getContributionType() {
        return TYPE;
    }

    public boolean canBeAccessedBy(User user) {
        return PublicationAccessControl.get().isUserAuthorized(user.getId(), this);
    }

    public boolean canBeModifiedBy(User user) {
        return PublicationAccessControl.get().isUserAuthorized(user.getId(), this, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}));
    }

    public boolean canBeFiledInBy(User user) {
        return this.canBeModifiedBy(user);
    }

    public static String getResourceType() {
        return TYPE;
    }

    @Override
    public String getSilverpeasContentId() {
        return this.getSilverObjectId();
    }

    public void setExplicitRank(int explicitRank) {
        this.explicitRank = explicitRank;
    }

    public int getExplicitRank() {
        return this.explicitRank;
    }

    @Override
    public ContributionRating getRating() {
        if (this.contributionRating == null) {
            this.contributionRating = RatingService.get().getRating(new ContributionRatingPK(this.getId(), this.getInstanceId(), TYPE));
        }
        return this.contributionRating;
    }

    public void setAuthorizedLocation(Location location) {
        if (location == null) {
            this.alias = false;
            this.authorizedLocation = null;
        } else {
            this.alias = location.isAlias();
            this.authorizedLocation = this.alias ? location : null;
        }
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public String getPermalink() {
        return URLUtil.getSimpleURL(2, this.getId(), this.authorizedLocation != null && !this.authorizedLocation.getInstanceId().equals(this.getInstanceId()) ? this.authorizedLocation.getInstanceId() : null);
    }

    public boolean isSharingAllowedForRolesFrom(UserDetail user) {
        if (!this.isValid() || this.isAlias()) {
            return false;
        }
        if (user == null || StringUtil.isNotDefined((String)user.getId()) || !user.isValidState()) {
            return false;
        }
        return PublicationAccessControl.get().isUserAuthorized(user.getId(), this, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.SHARING}));
    }

    public ContributionModel getModel() {
        return new PublicationDetailModel(this);
    }

    public String getMostRecentUpdater() {
        String userId = this.getUpdaterId();
        if (!StringUtil.isDefined((String)userId)) {
            userId = this.getCreatorId();
        }
        return userId;
    }

    public boolean isNew() {
        return NewContributionIndicator.isNewContribution((Contribution)this);
    }

    public static class Builder {
        private final PublicationDetail publication = new PublicationDetail();

        Builder(String language) {
            this.publication.setLanguage(language);
        }

        public PublicationDetail build() {
            if (this.publication.getPK() == null) {
                this.publication.setPk(new PublicationPK(""));
            }
            return this.publication;
        }

        public Builder setPk(PublicationPK pk) {
            this.publication.setPk(pk);
            return this;
        }

        public Builder created(Date creationDate, String creatorId) {
            this.publication.creationDate = creationDate;
            this.publication.creatorId = creatorId;
            return this;
        }

        public Builder updated(Date updateDate, String updaterId) {
            this.publication.updateDate = updateDate;
            this.publication.updaterId = updaterId;
            return this;
        }

        public Builder validated(Date validateDate, String validatorId) {
            this.publication.validateDate = validateDate;
            this.publication.validatorId = validatorId;
            return this;
        }

        public Builder setBeginDateTime(Date date, String hour) {
            this.publication.beginDate = date;
            this.publication.beginHour = hour;
            return this;
        }

        public Builder setEndDateTime(Date date, String hour) {
            this.publication.endDate = date;
            this.publication.endHour = hour;
            return this;
        }

        public Builder setImportance(int importance) {
            this.publication.importance = importance;
            return this;
        }

        public Builder setKeywords(String keywords) {
            this.publication.keywords = keywords;
            return this;
        }

        public Builder setContentPagePath(String contentPagePath) {
            this.publication.content = contentPagePath;
            return this;
        }

        public Builder setVersion(String version) {
            this.publication.version = version;
            return this;
        }

        public Builder setNameAndDescription(String name, String description) {
            this.publication.setName(name);
            this.publication.setDescription(description);
            return this;
        }

        public Builder removed(Date removalDate, String removerId) {
            this.publication.setRemovalDate(removalDate);
            this.publication.setRemoverId(removerId);
            return this;
        }
    }
}

