/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.contribution.publication.model.PublicationI18N;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationRuntimeException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.MapUtil;

public class PublicationI18NDAO {
    private static final String TABLENAME = "SB_Publication_PubliI18N";
    private static final String FIELDS = "id, pubId, lang, name, description, keywords";

    private PublicationI18NDAO() {
        throw new IllegalStateException("DAO class");
    }

    public static void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)TABLENAME).where("pubId in (" + JdbcSqlQuery.select((String)"pubId from SB_Publication_Publi").where("instanceId = ?", new Object[0]).getSqlQuery() + ")", new Object[]{componentInstanceId}).execute();
    }

    public static List<PublicationI18N> getTranslations(Connection con, PublicationPK pubPK) throws SQLException {
        String selectStatement = "select * from SB_Publication_PubliI18N where pubId = ? ";
        try (PreparedStatement stmt = con.prepareStatement("select * from SB_Publication_PubliI18N where pubId = ? ");){
            ArrayList<PublicationI18N> arrayList;
            block13: {
                stmt.setInt(1, Integer.parseInt(pubPK.getId()));
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<PublicationI18N> list = new ArrayList<PublicationI18N>();
                    while (rs.next()) {
                        list.add(PublicationI18NDAO.resultSetToEntity(rs));
                    }
                    arrayList = list;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public static Map<String, List<PublicationI18N>> getIndexedTranslations(Connection con, List<String> publicationIds) throws SQLException {
        return JdbcSqlQuery.executeBySplittingOn(publicationIds, (idBatch, result) -> JdbcSqlQuery.select((String)FIELDS).from(new String[]{TABLENAME}).where("pubId", new Object[0]).in((Collection)idBatch.stream().map(Integer::parseInt).collect(Collectors.toList())).executeWith(con, r -> {
            PublicationI18N pub = PublicationI18NDAO.resultSetToEntity((ResultSet)r);
            MapUtil.putAddList(result, pub.getObjectId(), pub);
            return null;
        }));
    }

    private static PublicationI18N resultSetToEntity(ResultSet r) throws SQLException {
        PublicationI18N pub = new PublicationI18N();
        pub.setId(String.valueOf(r.getInt(1)));
        pub.setObjectId(Integer.toString(r.getInt(2)));
        pub.setLanguage(r.getString(3));
        pub.setName(r.getString(4));
        pub.setDescription(r.getString(5));
        pub.setKeywords(r.getString(6));
        return pub;
    }

    public static void addTranslation(Connection con, PublicationI18N translation) throws SQLException {
        StringBuilder insertStatement = new StringBuilder(128);
        insertStatement.append("insert into ").append(TABLENAME).append(" values (?, ?, ?, ?, ?, ?)");
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement.toString());){
            prepStmt.setInt(1, DBUtil.getNextId((String)TABLENAME, (String)"id"));
            prepStmt.setInt(2, Integer.parseInt(translation.getObjectId()));
            prepStmt.setString(3, translation.getLanguage());
            prepStmt.setString(4, translation.getName());
            prepStmt.setString(5, translation.getDescription());
            prepStmt.setString(6, translation.getKeywords());
            prepStmt.executeUpdate();
        }
    }

    public static void updateTranslation(Connection con, PublicationI18N translation) throws SQLException {
        int rowCount;
        StringBuilder updateQuery = new StringBuilder(128);
        updateQuery.append("update ").append(TABLENAME);
        updateQuery.append(" set name = ? , description = ? , keywords = ? ");
        updateQuery.append(" where id = ? ");
        try (PreparedStatement prepStmt = con.prepareStatement(updateQuery.toString());){
            prepStmt.setString(1, translation.getName());
            prepStmt.setString(2, translation.getDescription());
            prepStmt.setString(3, translation.getKeywords());
            prepStmt.setInt(4, Integer.parseInt(translation.getId()));
            rowCount = prepStmt.executeUpdate();
        }
        if (rowCount == 0) {
            throw new PublicationRuntimeException("The update of the translation with id = " + translation.getId() + " failed!");
        }
    }

    public static void removeTranslation(Connection con, String translationId) throws SQLException {
        PublicationI18NDAO.removeTranslation(con, Integer.parseInt(translationId));
    }

    public static void removeTranslation(Connection con, int translationId) throws SQLException {
        StringBuilder deleteStatement = new StringBuilder(128);
        deleteStatement.append("delete from ").append(TABLENAME).append(" where id = ? ");
        try (PreparedStatement stmt = con.prepareStatement(deleteStatement.toString());){
            stmt.setInt(1, translationId);
            stmt.executeUpdate();
        }
    }

    public static void removeTranslations(Connection con, PublicationPK pubPK) throws SQLException {
        StringBuilder deleteStatement = new StringBuilder(128);
        deleteStatement.append("delete from ").append(TABLENAME).append(" where pubId = ? ");
        try (PreparedStatement stmt = con.prepareStatement(deleteStatement.toString());){
            stmt.setInt(1, Integer.parseInt(pubPK.getId()));
            stmt.executeUpdate();
        }
    }
}

